/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.log.LogEvent;
import org.apache.log.LogTarget;
import org.apache.log.format.PatternFormatter;

public class LoggerPanel
extends JPanel
implements LogTarget {
    private static final long serialVersionUID = 6911128494402594429L;
    private final JTextArea textArea = this.init();
    private final PatternFormatter format = new PatternFormatter("%{time:yyyy/MM/dd HH:mm:ss} %5.5{priority} - %{category}: %{message} %{throwable}\n");
    private static final int LOGGER_PANEL_MAX_LENGTH = JMeterUtils.getPropDefault("jmeter.loggerpanel.maxlength", 80000);
    private static final boolean LOGGER_PANEL_RECEIVE_WHEN_CLOSED = JMeterUtils.getPropDefault("jmeter.loggerpanel.enable_when_closed", true);

    private JTextArea init() {
        Object jTextArea;
        Object areaScrollPane;
        this.setLayout(new BorderLayout());
        if (JMeterUtils.getPropDefault("loggerpanel.usejsyntaxtext", true)) {
            JSyntaxTextArea jSyntaxTextArea = new JSyntaxTextArea(15, 80, true);
            jSyntaxTextArea.setSyntaxEditingStyle("text/plain");
            jSyntaxTextArea.setCodeFoldingEnabled(false);
            jSyntaxTextArea.setAntiAliasingEnabled(false);
            jSyntaxTextArea.setEditable(false);
            jSyntaxTextArea.setLineWrap(false);
            jSyntaxTextArea.setLanguage("text");
            jSyntaxTextArea.setMargin(new Insets(2, 2, 2, 2));
            areaScrollPane = new JTextScrollPane(jSyntaxTextArea);
            jTextArea = jSyntaxTextArea;
        } else {
            jTextArea = new JTextArea(15, 80);
            areaScrollPane = new JScrollPane((Component)jTextArea);
        }
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setHorizontalScrollBarPolicy(30);
        this.add((Component)areaScrollPane, "Center");
        return jTextArea;
    }

    public void processEvent(final LogEvent logEvent) {
        if (!LOGGER_PANEL_RECEIVE_WHEN_CLOSED && !GuiPackage.getInstance().getMenuItemLoggerPanel().getModel().isSelected()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JTextArea jTextArea = LoggerPanel.this.textArea;
                synchronized (jTextArea) {
                    LoggerPanel.this.textArea.append(LoggerPanel.this.format.format(logEvent));
                    int currentLength = LoggerPanel.this.textArea.getText().length();
                    if (LOGGER_PANEL_MAX_LENGTH != 0 && currentLength > LOGGER_PANEL_MAX_LENGTH) {
                        LoggerPanel.this.textArea.setText(LoggerPanel.this.textArea.getText().substring(Math.max(0, currentLength - LOGGER_PANEL_MAX_LENGTH), currentLength));
                    }
                    LoggerPanel.this.textArea.setCaretPosition(LoggerPanel.this.textArea.getText().length());
                }
            }
        });
    }

    public void clear() {
        this.textArea.setText("");
    }
}

