/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataFactory;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.Join;

public class JoinArray
implements Join {
    VariableDS v;
    Array data;
    Type type;
    int param;

    public JoinArray(VariableDS v, Type type, int param) {
        this.v = v;
        this.type = type;
        this.param = param;
        try {
            this.data = v.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public StructureData getJoinData(Cursor cursor) {
        int recnum = -1;
        switch (this.type) {
            case modulo: {
                recnum = cursor.recnum[0] % this.param;
                break;
            }
            case divide: {
                recnum = cursor.recnum[0] / this.param;
                break;
            }
            case level: {
                recnum = cursor.recnum[this.param];
                break;
            }
            case raw: {
                recnum = cursor.recnum[0];
                break;
            }
            case scalar: {
                recnum = 0;
            }
        }
        return StructureDataFactory.make(this.v.getShortName(), this.data.getObject(recnum));
    }

    @Override
    public VariableDS findVariable(String varName) {
        return varName.equals(this.v.getName()) ? this.v : null;
    }

    public String toString() {
        return "JoinArray{v=" + this.v.getName() + ", type=" + (Object)((Object)this.type) + ", param=" + this.param + '}';
    }

    public static enum Type {
        modulo,
        divide,
        level,
        raw,
        scalar;

    }
}

