/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.pool;

import org.apache.avalon.excalibur.pool.DefaultObjectFactory;
import org.apache.avalon.excalibur.pool.DefaultPool;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.PoolController;
import org.apache.avalon.excalibur.pool.Resizable;

public class SoftResourceLimitingPool
extends DefaultPool
implements Resizable {
    public SoftResourceLimitingPool(ObjectFactory factory) throws Exception {
        this(factory, 4);
    }

    public SoftResourceLimitingPool(ObjectFactory factory, int min) throws Exception {
        this(factory, null, min, min * 2);
    }

    public SoftResourceLimitingPool(ObjectFactory factory, int min, int max) throws Exception {
        this(factory, null, min, max);
    }

    public SoftResourceLimitingPool(ObjectFactory factory, PoolController controller, int min, int max) throws Exception {
        super(factory, controller, min, max);
    }

    public SoftResourceLimitingPool(Class clazz, int initial, int maximum) throws NoSuchMethodException, Exception {
        this(new DefaultObjectFactory(clazz), initial, maximum);
    }

    public SoftResourceLimitingPool(Class clazz, int initial) throws NoSuchMethodException, Exception {
        this(clazz, initial, initial);
    }

    public void initialize() throws Exception {
        this.grow(this.m_min);
        this.m_initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grow(int amount) {
        try {
            this.m_mutex.acquire();
            this.internalGrow(amount);
        }
        catch (InterruptedException ie) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Interrupted while waiting on lock", (Throwable)ie);
            }
        }
        catch (Exception e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Could not grow the pool properly, an exception was caught", (Throwable)e);
            }
        }
        finally {
            this.m_mutex.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shrink(int amount) {
        try {
            this.m_mutex.acquire();
            this.internalShrink(amount);
        }
        catch (InterruptedException ie) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Interrupted while waiting on lock", (Throwable)ie);
            }
        }
        catch (Exception e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Could not shrink the pool properly, an exception was caught", (Throwable)e);
            }
        }
        finally {
            this.m_mutex.release();
        }
    }
}

