/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.iosp.IndexChunker;
import ucar.nc2.iosp.Layout;

public class LayoutSegmented
implements Layout {
    private long total;
    private long done;
    private int elemSize;
    private long[] segPos;
    private long[] segMax;
    private long[] segMin;
    private IndexChunker chunker;
    private IndexChunker.Chunk chunkOuter;
    private IndexChunker.Chunk chunkInner = new IndexChunker.Chunk(0L, 0, 0L);
    private boolean debugNext = false;
    private int needInner = 0;
    private int doneInner = 0;

    public LayoutSegmented(long[] segPos, int[] segSize, int elemSize, int[] srcShape, Section wantSection) throws InvalidRangeException {
        assert (segPos.length == segSize.length);
        this.segPos = segPos;
        int nsegs = segPos.length;
        this.segMin = new long[nsegs];
        this.segMax = new long[nsegs];
        long totalElems = 0L;
        for (int i = 0; i < nsegs; ++i) {
            assert (segPos[i] >= 0L);
            assert (segSize[i] > 0);
            assert (segSize[i] % elemSize == 0);
            this.segMin[i] = totalElems;
            this.segMax[i] = totalElems += (long)segSize[i];
        }
        assert (totalElems >= Index.computeSize(srcShape) * (long)elemSize);
        this.chunker = new IndexChunker(srcShape, wantSection);
        this.total = this.chunker.getTotalNelems();
        this.done = 0L;
        this.elemSize = elemSize;
    }

    @Override
    public long getTotalNelems() {
        return this.total;
    }

    @Override
    public int getElemSize() {
        return this.elemSize;
    }

    @Override
    public boolean hasNext() {
        return this.done < this.total;
    }

    private long getFilePos(long elem) {
        int segno = 0;
        while (elem >= this.segMax[segno]) {
            ++segno;
        }
        return this.segPos[segno] + elem - this.segMin[segno];
    }

    private int getMaxBytes(long start) {
        int segno = 0;
        while (start >= this.segMax[segno]) {
            ++segno;
        }
        return (int)(this.segMax[segno] - start);
    }

    @Override
    public Layout.Chunk next() {
        Layout.Chunk result = null;
        if (this.needInner > 0) {
            result = this.nextInner(false, 0);
        } else {
            result = this.nextOuter();
            int nbytes = this.getMaxBytes(this.chunkOuter.getSrcElem() * (long)this.elemSize);
            if (nbytes < result.getNelems() * this.elemSize) {
                result = this.nextInner(true, nbytes);
            }
        }
        this.done += (long)result.getNelems();
        this.doneInner += result.getNelems();
        this.needInner -= result.getNelems();
        if (this.debugNext) {
            System.out.println(" next chunk: " + result);
        }
        return result;
    }

    private Layout.Chunk nextInner(boolean first, int nbytes) {
        if (first) {
            this.chunkInner.setNelems(nbytes / this.elemSize);
            this.chunkInner.setDestElem(this.chunkOuter.getDestElem());
            this.needInner = this.chunkOuter.getNelems();
            this.doneInner = 0;
        } else {
            this.chunkInner.incrDestElem(this.chunkInner.getNelems());
            nbytes = this.getMaxBytes((this.chunkOuter.getSrcElem() + (long)this.doneInner) * (long)this.elemSize);
            nbytes = Math.min(nbytes, this.needInner * this.elemSize);
            this.chunkInner.setNelems(nbytes / this.elemSize);
        }
        this.chunkInner.setSrcPos(this.getFilePos((this.chunkOuter.getSrcElem() + (long)this.doneInner) * (long)this.elemSize));
        return this.chunkInner;
    }

    public Layout.Chunk nextOuter() {
        this.chunkOuter = this.chunker.next();
        long srcPos = this.getFilePos(this.chunkOuter.getSrcElem() * (long)this.elemSize);
        this.chunkOuter.setSrcPos(srcPos);
        return this.chunkOuter;
    }
}

