/*
 * Decompiled with CFR 0.152.
 */
package org.jmock;

import org.jmock.Mock;
import org.jmock.core.CoreMock;
import org.jmock.core.DynamicMock;
import org.jmock.core.Formatting;
import org.jmock.core.InvocationMatcher;
import org.jmock.core.MockObjectSupportTestCase;
import org.jmock.core.Stub;
import org.jmock.core.matcher.InvokeAtLeastOnceMatcher;
import org.jmock.core.matcher.InvokeOnceMatcher;
import org.jmock.core.matcher.TestFailureMatcher;
import org.jmock.core.stub.ReturnStub;
import org.jmock.core.stub.StubSequence;
import org.jmock.core.stub.ThrowStub;

public abstract class MockObjectTestCase
extends MockObjectSupportTestCase {
    public MockObjectTestCase() {
    }

    public MockObjectTestCase(String string) {
        super(string);
    }

    public Mock mock(Class clazz) {
        return this.mock(clazz, this.defaultMockNameForType(clazz));
    }

    public Mock mock(Class clazz, String string) {
        Mock mock = new Mock(this.newCoreMock(clazz, string));
        this.registerToVerify(mock);
        return mock;
    }

    protected DynamicMock newCoreMock(Class clazz, String string) {
        return new CoreMock(clazz, string);
    }

    public String defaultMockNameForType(Class clazz) {
        return "mock" + Formatting.classShortName(clazz);
    }

    public Stub returnValue(Object object) {
        return new ReturnStub(object);
    }

    public Stub returnValue(boolean bl) {
        return this.returnValue(new Boolean(bl));
    }

    public Stub returnValue(byte by) {
        return this.returnValue(new Byte(by));
    }

    public Stub returnValue(char c) {
        return this.returnValue(new Character(c));
    }

    public Stub returnValue(short s) {
        return this.returnValue(new Short(s));
    }

    public Stub returnValue(int n) {
        return this.returnValue(new Integer(n));
    }

    public Stub returnValue(long l) {
        return this.returnValue(new Long(l));
    }

    public Stub returnValue(float f) {
        return this.returnValue(new Float(f));
    }

    public Stub returnValue(double d) {
        return this.returnValue(new Double(d));
    }

    public Stub throwException(Throwable throwable) {
        return new ThrowStub(throwable);
    }

    public InvocationMatcher once() {
        return new InvokeOnceMatcher();
    }

    public InvocationMatcher atLeastOnce() {
        return new InvokeAtLeastOnceMatcher();
    }

    public InvocationMatcher never() {
        return new TestFailureMatcher("expect not called");
    }

    public Stub onConsecutiveCalls(Stub stub, Stub stub2) {
        return new StubSequence(new Stub[]{stub, stub2});
    }

    public Stub onConsecutiveCalls(Stub stub, Stub stub2, Stub stub3) {
        return new StubSequence(new Stub[]{stub, stub2, stub3});
    }

    public Stub onConsecutiveCalls(Stub stub, Stub stub2, Stub stub3, Stub stub4) {
        return new StubSequence(new Stub[]{stub, stub2, stub3, stub4});
    }
}

