/*
 * Decompiled with CFR 0.152.
 */
package com.rmemoria.datastream.impl;

import com.rmemoria.datastream.StreamContext;
import com.rmemoria.datastream.impl.Constants;
import com.rmemoria.datastream.impl.PropertyMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyValue {
    private PropertyMetaData property;
    private Object value;
    private PropertyValue parent;
    private List<PropertyValue> properties;

    public PropertyValue(PropertyValue parent, PropertyMetaData property, Object value) {
        this.property = property;
        this.value = value;
        this.parent = parent;
    }

    public PropertyValue addChildValue(PropertyMetaData property, Object value) {
        if (this.properties == null) {
            this.properties = new ArrayList<PropertyValue>();
        }
        PropertyValue pv = new PropertyValue(this.parent, property, value);
        this.properties.add(pv);
        return pv;
    }

    public void writePropertyValue(StreamContext context, Object owner) {
        PropertyMetaData linkprop;
        if (this.value == null && this.properties != null) {
            this.value = this.createValue(context);
        }
        PropertyMetaData propertyMetaData = linkprop = this.property.getTypeMetaData() != null ? this.property.getTypeMetaData().getLinkParentObject() : null;
        if (this.property.isCollection()) {
            if (this.value != null) {
                Collection lst = this.property.getCollectionObject(context, owner);
                for (Object item : (Collection)this.value) {
                    lst.add(item);
                    if (linkprop == null) continue;
                    linkprop.getFieldAccess().setValue(item, owner);
                }
            }
        } else {
            this.getProperty().getFieldAccess().setValue(owner, this.value);
            if (linkprop != null) {
                linkprop.getFieldAccess().setValue(this.value, owner);
            }
        }
        if (this.properties != null && this.value != null) {
            for (PropertyValue pv : this.properties) {
                pv.writePropertyValue(context, this.value);
            }
        }
    }

    protected Object createValue(StreamContext context) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.addAttributes(params, this.property);
        return context.createInstance(this.getProperty().getPropertyType(), params);
    }

    public void addAttributes(Map<String, Object> attrs, PropertyMetaData limitParent) {
        if (this.value != null && this.value != Constants.NULL_VALUE) {
            attrs.put(this.property.getPath(limitParent), this.value);
        }
        if (this.properties != null) {
            for (PropertyValue aux : this.properties) {
                aux.addAttributes(attrs, limitParent);
            }
        }
    }

    public PropertyValue findChildPropertyValue(PropertyMetaData prop) {
        if (this.properties == null) {
            return null;
        }
        for (PropertyValue pv : this.properties) {
            if (pv.getProperty() != prop) continue;
            return pv;
        }
        return null;
    }

    public PropertyValue findChildPropertyByName(String propname) {
        if (this.properties == null) {
            return null;
        }
        for (PropertyValue pv : this.properties) {
            if (!pv.getProperty().getPropertyName().equals(propname)) continue;
            return pv;
        }
        return null;
    }

    public int getPropertyCount() {
        return this.properties != null ? this.properties.size() : 0;
    }

    public List<PropertyValue> getProperties() {
        return this.properties;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public PropertyMetaData getProperty() {
        return this.property;
    }

    public Object getValue() {
        return this.value;
    }

    public PropertyValue getParent() {
        return this.parent;
    }

    public String toString() {
        String s = this.property.toString();
        if (this.properties != null) {
            return s + "=[" + this.properties.size() + " value(s)]";
        }
        return s + "=" + this.value;
    }
}

