/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.apache.jmeter.gui.util.JMeterColor;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.visualizers.CachingStatCalculator;
import org.apache.jmeter.visualizers.Sample;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class Graph
extends JComponent
implements Scrollable,
Clearable {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private boolean wantData = true;
    private boolean wantAverage = true;
    private boolean wantDeviation = true;
    private boolean wantThroughput = true;
    private boolean wantMedian = true;
    private CachingStatCalculator model;
    private static final int width = 2000;
    private long graphMax = 1L;
    private double throughputMax = 1.0;

    public Graph() {
        this.setPreferredSize(new Dimension(2000, 100));
    }

    public Graph(CachingStatCalculator model) {
        this();
        this.model = model;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return (int)((double)visibleRect.width * 0.9);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    public void clearData() {
        this.graphMax = 1L;
        this.throughputMax = 1.0;
    }

    public void enableData(boolean value) {
        this.wantData = value;
    }

    public void enableAverage(boolean value) {
        this.wantAverage = value;
    }

    public void enableMedian(boolean value) {
        this.wantMedian = value;
    }

    public void enableDeviation(boolean value) {
        this.wantDeviation = value;
    }

    public void enableThroughput(boolean value) {
        this.wantThroughput = value;
    }

    public void updateGui(final Sample oneSample) {
        long h = this.model.getPercentPoint(0.9f).longValue();
        boolean repaint = false;
        if ((oneSample.getCount() % 20L == 0L || oneSample.getCount() < 20L) && (double)h > (double)this.graphMax * 1.2 || (double)this.graphMax > (double)h * 1.2) {
            this.graphMax = h >= 1L ? h : 1L;
            repaint = true;
        }
        if (this.model.getMaxThroughput() > this.throughputMax) {
            this.throughputMax = this.model.getMaxThroughput() * 1.3;
            repaint = true;
        }
        if (repaint) {
            this.repaint();
            return;
        }
        final long xPos = this.model.getCount();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Graphics g = Graph.this.getGraphics();
                if (g != null) {
                    Graph.this.drawSample(xPos, oneSample, g);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        List samples;
        super.paintComponent(g);
        List list = samples = this.model.getSamples();
        synchronized (list) {
            Iterator e = samples.iterator();
            int i = 0;
            while (e.hasNext()) {
                Sample s = (Sample)e.next();
                this.drawSample(i, s, g);
                ++i;
            }
        }
    }

    private void drawSample(long x, Sample oneSample, Graphics g) {
        int height = this.getHeight();
        log.debug("Drawing a sample at " + x);
        int adjustedWidth = (int)(x % 2000L);
        if (this.wantData) {
            int data = (int)(oneSample.getData() * (long)height / this.graphMax);
            if (oneSample.isSuccess()) {
                g.setColor(Color.black);
            } else {
                g.setColor(Color.YELLOW);
            }
            g.drawLine(adjustedWidth, height - data, adjustedWidth, height - data - 1);
            if (log.isDebugEnabled()) {
                log.debug("Drawing coords = " + adjustedWidth + "," + (height - data));
            }
        }
        if (this.wantAverage) {
            int average = (int)(oneSample.getAverage() * (long)height / this.graphMax);
            g.setColor(Color.blue);
            g.drawLine(adjustedWidth, height - average, adjustedWidth, height - average - 1);
        }
        if (this.wantMedian) {
            int median = (int)(oneSample.getMedian() * (long)height / this.graphMax);
            g.setColor(JMeterColor.purple);
            g.drawLine(adjustedWidth, height - median, adjustedWidth, height - median - 1);
        }
        if (this.wantDeviation) {
            int deviation = (int)(oneSample.getDeviation() * (long)height / this.graphMax);
            g.setColor(Color.red);
            g.drawLine(adjustedWidth, height - deviation, adjustedWidth, height - deviation - 1);
        }
        if (this.wantThroughput) {
            int throughput = (int)(oneSample.getThroughput() * (double)height / this.throughputMax);
            g.setColor(JMeterColor.dark_green);
            g.drawLine(adjustedWidth, height - throughput, adjustedWidth, height - throughput - 1);
        }
    }

    public long getGraphMax() {
        return this.graphMax;
    }
}

