/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.ReplaceableController;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;

public class ModuleController
extends GenericController
implements ReplaceableController {
    private static final long serialVersionUID = 240L;
    private static final String NODE_PATH = "ModuleController.node_path";
    private transient JMeterTreeNode selectedNode = null;

    public Object clone() {
        ModuleController clone = (ModuleController)((Object)super.clone());
        if (this.selectedNode == null) {
            this.restoreSelected();
        }
        clone.selectedNode = this.selectedNode;
        return clone;
    }

    public void setSelectedNode(JMeterTreeNode tn) {
        this.selectedNode = tn;
        this.setNodePath();
    }

    public JMeterTreeNode getSelectedNode() {
        if (this.selectedNode == null) {
            this.restoreSelected();
        }
        return this.selectedNode;
    }

    private void setNodePath() {
        ArrayList<String> nodePath = new ArrayList<String>();
        if (this.selectedNode != null) {
            TreeNode[] path;
            for (TreeNode node : path = this.selectedNode.getPath()) {
                nodePath.add(((JMeterTreeNode)node).getName());
            }
        }
        this.setProperty((JMeterProperty)new CollectionProperty(NODE_PATH, nodePath));
    }

    public List<?> getNodePath() {
        JMeterProperty prop = this.getProperty(NODE_PATH);
        if (!(prop instanceof NullProperty)) {
            return (List)((CollectionProperty)prop).getObjectValue();
        }
        return null;
    }

    private void restoreSelected() {
        GuiPackage gp = GuiPackage.getInstance();
        if (gp != null) {
            JMeterTreeNode root = (JMeterTreeNode)gp.getTreeModel().getRoot();
            this.resolveReplacementSubTree(root);
        }
    }

    public void resolveReplacementSubTree(JMeterTreeNode context) {
        List<?> nodePathList;
        if (this.selectedNode == null && (nodePathList = this.getNodePath()) != null && nodePathList.size() > 0) {
            this.traverse(context, nodePathList, 1);
        }
    }

    private void traverse(JMeterTreeNode node, List<?> nodePath, int level) {
        if (node != null && nodePath.size() > level) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                JMeterTreeNode cur = (JMeterTreeNode)node.getChildAt(i);
                if (cur.getTestElement() instanceof ModuleController || !cur.getName().equals(nodePath.get(level).toString())) continue;
                if (nodePath.size() == level + 1) {
                    this.selectedNode = cur;
                }
                this.traverse(cur, nodePath, level + 1);
            }
        }
    }

    public HashTree getReplacementSubTree() {
        ListedHashTree tree = new ListedHashTree();
        if (this.selectedNode != null) {
            JMeterTreeNode nodeToReplace = this.selectedNode;
            if (!nodeToReplace.isEnabled()) {
                nodeToReplace = ModuleController.cloneTreeNode(this.selectedNode);
                nodeToReplace.setEnabled(true);
            }
            HashTree subtree = tree.add((Object)nodeToReplace);
            this.createSubTree(subtree, nodeToReplace);
        }
        return tree;
    }

    private void createSubTree(HashTree tree, JMeterTreeNode node) {
        Enumeration e = node.children();
        while (e.hasMoreElements()) {
            JMeterTreeNode subNode = (JMeterTreeNode)e.nextElement();
            tree.add((Object)subNode);
            this.createSubTree(tree.getTree((Object)subNode), subNode);
        }
    }

    private static JMeterTreeNode cloneTreeNode(JMeterTreeNode node) {
        JMeterTreeNode treeNode = (JMeterTreeNode)node.clone();
        treeNode.setUserObject(((TestElement)node.getUserObject()).clone());
        ModuleController.cloneChildren(treeNode, node);
        return treeNode;
    }

    private static void cloneChildren(JMeterTreeNode to, JMeterTreeNode from) {
        Enumeration enumr = from.children();
        while (enumr.hasMoreElements()) {
            JMeterTreeNode child = (JMeterTreeNode)enumr.nextElement();
            JMeterTreeNode childClone = (JMeterTreeNode)child.clone();
            childClone.setUserObject(((TestElement)child.getUserObject()).clone());
            to.add((MutableTreeNode)childClone);
            ModuleController.cloneChildren((JMeterTreeNode)to.getLastChild(), child);
        }
    }
}

