/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger;

import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;

public final class DefaultLoggerManager
implements LoggerManager,
ThreadSafe,
LogEnabled,
Contextualizable,
Configurable,
Serviceable,
Disposable {
    private LoggerManager m_loggermanager;
    private Context m_context;
    private Logger m_logger;
    private String m_prefix;
    private ServiceManager m_manager;
    private boolean m_disposeManager = false;
    static /* synthetic */ Class class$java$lang$String;

    public DefaultLoggerManager() {
    }

    public DefaultLoggerManager(String prefix) {
        this.m_prefix = prefix;
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public final Logger getLoggerForCategory(String categoryName) {
        return this.m_loggermanager.getLoggerForCategory(categoryName);
    }

    public final Logger getDefaultLogger() {
        return this.m_loggermanager.getDefaultLogger();
    }

    public final void contextualize(Context context) throws ContextException {
        this.m_context = context;
    }

    public final void configure(Configuration configuration) throws ConfigurationException {
        String className = configuration.getAttribute("manager-class", null);
        if (null != className) {
            String prefix = configuration.getAttribute("prefix", this.m_prefix);
            try {
                this.m_loggermanager = null == prefix ? (LoggerManager)Class.forName(className).newInstance() : (LoggerManager)Class.forName(className).getConstructor(class$java$lang$String == null ? (class$java$lang$String = DefaultLoggerManager.class$("java.lang.String")) : class$java$lang$String).newInstance(prefix);
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to create new logger manager for class " + className, (Throwable)e);
            }
            ContainerUtil.enableLogging((Object)this.m_loggermanager, (Logger)this.m_logger);
            try {
                ContainerUtil.contextualize((Object)this.m_loggermanager, (Context)this.m_context);
            }
            catch (ContextException ce) {
                throw new ConfigurationException("Unable to contextualize new logger manager.", (Throwable)ce);
            }
            try {
                ContainerUtil.service((Object)this.m_loggermanager, (ServiceManager)this.m_manager);
            }
            catch (ServiceException se) {
                throw new ConfigurationException("Unable to service new logger manager.", (Throwable)se);
            }
            if (this.m_loggermanager instanceof Configurable) {
                ((Configurable)this.m_loggermanager).configure(configuration.getChildren()[0]);
            } else if (this.m_loggermanager instanceof Parameterizable) {
                try {
                    ((Parameterizable)this.m_loggermanager).parameterize(Parameters.fromConfiguration((Configuration)configuration.getChildren()[0]));
                }
                catch (ParameterException pe) {
                    throw new ConfigurationException("Unable to parameterize new logger manager.", (Throwable)pe);
                }
            }
            try {
                ContainerUtil.initialize((Object)this.m_loggermanager);
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to initialize new logger manager.");
            }
        }
        String roleName = configuration.getAttribute("manager-role", null);
        if (null == roleName) {
            throw new ConfigurationException("The LoggerManager needs either a manager-role or a manager-class");
        }
        try {
            this.m_loggermanager = (LoggerManager)this.m_manager.lookup(roleName);
            this.m_disposeManager = true;
        }
        catch (ServiceException e) {
            throw new ConfigurationException("Unable to lookup logger manager with role " + roleName);
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.m_manager = manager;
    }

    public void dispose() {
        if (this.m_disposeManager && null != this.m_manager) {
            this.m_manager.release((Object)this.m_loggermanager);
        }
        this.m_manager = null;
        this.m_loggermanager = null;
        this.m_disposeManager = false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

