/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class RandomString
extends AbstractFunction {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__RandomString";
    private CompoundVariable[] values;
    private static final int MAX_PARAM_COUNT = 3;
    private static final int MIN_PARAM_COUNT = 1;
    private static final int CHARS = 2;
    private static final int PARAM_NAME = 3;

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars;
        int length = Integer.parseInt(this.values[0].execute());
        String charsToUse = null;
        if (this.values.length >= 2 && (charsToUse = this.values[1].execute().trim()).length() <= 0) {
            charsToUse = null;
        }
        String myName = "";
        if (this.values.length >= 3) {
            myName = this.values[2].execute().trim();
        }
        String myValue = null;
        myValue = StringUtils.isEmpty((CharSequence)charsToUse) ? RandomStringUtils.random((int)length) : RandomStringUtils.random((int)length, (String)charsToUse);
        if (myName.length() > 0 && (vars = this.getVariables()) != null) {
            vars.put(myName, myValue);
        }
        if (log.isDebugEnabled()) {
            String tn = Thread.currentThread().getName();
            log.debug(tn + " name:" + myName + " value:" + myValue);
        }
        return myValue;
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 3);
        this.values = parameters.toArray(new CompoundVariable[parameters.size()]);
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"random_string_length"));
        desc.add(JMeterUtils.getResString((String)"random_string_chars_to_use"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
    }
}

