/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config;

import java.io.Serializable;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jorphan.util.JOrphanUtils;

public class Argument
extends AbstractTestElement
implements Serializable {
    private static final long serialVersionUID = 240L;
    public static final String ARG_NAME = "Argument.name";
    public static final String VALUE = "Argument.value";
    public static final String DESCRIPTION = "Argument.desc";
    private static final String DFLT_DESCRIPTION = "";
    public static final String METADATA = "Argument.metadata";

    public Argument() {
        this(null, null, null, null);
    }

    public Argument(String name, String value) {
        this(name, value, null, null);
    }

    public Argument(String name, String value, String metadata) {
        this(name, value, metadata, null);
    }

    public Argument(String name, String value, String metadata, String description) {
        if (name != null) {
            this.setProperty(new StringProperty(ARG_NAME, name));
        }
        if (value != null) {
            this.setProperty(new StringProperty(VALUE, value));
        }
        if (metadata != null) {
            this.setProperty(new StringProperty(METADATA, metadata));
        }
        if (description != null) {
            this.setProperty(DESCRIPTION, description, DFLT_DESCRIPTION);
        }
    }

    @Override
    public void setName(String newName) {
        this.setProperty(new StringProperty(ARG_NAME, newName));
    }

    @Override
    public String getName() {
        return this.getPropertyAsString(ARG_NAME);
    }

    public void setValue(String newValue) {
        this.setProperty(new StringProperty(VALUE, newValue));
    }

    public String getValue() {
        return this.getPropertyAsString(VALUE);
    }

    public void setDescription(String description) {
        this.setProperty(DESCRIPTION, description, DFLT_DESCRIPTION);
    }

    public String getDescription() {
        return this.getPropertyAsString(DESCRIPTION, DFLT_DESCRIPTION);
    }

    public void setMetaData(String newMetaData) {
        this.setProperty(new StringProperty(METADATA, newMetaData));
    }

    public String getMetaData() {
        return this.getPropertyAsString(METADATA);
    }

    public String toString() {
        return this.getName() + this.getMetaData() + this.getValue();
    }

    public boolean isSkippable(String parameterName) {
        if (JOrphanUtils.isBlank((String)parameterName)) {
            return true;
        }
        return parameterName.trim().startsWith("${") && parameterName.endsWith("}");
    }
}

