/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.avalon.excalibur.datasource.PoolSettable;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.excalibur.pool.ValidatedResourceLimitingPool;

public class ResourceLimitingJdbcConnectionPool
extends ValidatedResourceLimitingPool {
    private boolean m_autoCommit;

    public ResourceLimitingJdbcConnectionPool(ObjectFactory factory, int max, boolean maxStrict, boolean blocking, long blockTimeout, long trimInterval, boolean autoCommit) {
        super(factory, max, maxStrict, blocking, blockTimeout, trimInterval);
        this.m_autoCommit = autoCommit;
    }

    protected Poolable newPoolable() throws Exception {
        Poolable pooledObject = super.newPoolable();
        if (null == pooledObject) {
            throw new SQLException("Could not create a connection.");
        }
        PoolSettable conn = (PoolSettable)pooledObject;
        conn.setPool((Pool)this);
        ((Connection)((Object)conn)).setAutoCommit(this.m_autoCommit);
        return conn;
    }

    protected boolean validatePoolable(Poolable poolable) {
        PoolSettable conn = (PoolSettable)poolable;
        try {
            if (((Connection)((Object)conn)).isClosed()) {
                this.getLogger().debug("JdbcConnection was closed.");
                return false;
            }
            ((Connection)((Object)conn)).setAutoCommit(this.m_autoCommit);
        }
        catch (SQLException e) {
            this.getLogger().debug("Failed to check whether JdbcConnection was closed. " + e.getMessage());
        }
        return true;
    }
}

