/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointIteratorFiltered;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonRect;

public abstract class PointCollectionImpl
implements PointFeatureCollection {
    protected String name;
    protected LatLonRect boundingBox;
    protected DateRange dateRange;
    protected int npts;
    protected PointFeatureIterator localIterator;

    protected PointCollectionImpl(String name) {
        this.name = name;
        this.npts = -1;
    }

    protected PointCollectionImpl(String name, LatLonRect boundingBox, DateRange dateRange, int npts) {
        this.name = name;
        this.boundingBox = boundingBox;
        this.dateRange = dateRange;
        this.npts = npts;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    @Override
    public void finish() {
        if (this.localIterator != null) {
            this.localIterator.finish();
        }
    }

    @Override
    public PointFeature next() throws IOException {
        return this.localIterator.next();
    }

    @Override
    public void resetIteration() throws IOException {
        this.localIterator = this.getPointFeatureIterator(-1);
    }

    @Override
    public int size() {
        return this.npts;
    }

    @Override
    public DateRange getDateRange() {
        return this.dateRange;
    }

    @Override
    public LatLonRect getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public void setDateRange(DateRange range) {
        this.dateRange = range;
    }

    @Override
    public void setBoundingBox(LatLonRect bb) {
        this.boundingBox = bb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calcBounds() throws IOException {
        if (this.dateRange != null && this.boundingBox != null && this.size() > 0) {
            return;
        }
        PointFeatureIterator iter = this.getPointFeatureIterator(-1);
        iter.setCalculateBounds(this);
        try {
            while (iter.hasNext()) {
                iter.next();
            }
        }
        finally {
            iter.finish();
        }
    }

    @Override
    public void setSize(int npts) {
        this.npts = npts;
    }

    @Override
    public FeatureType getCollectionFeatureType() {
        return FeatureType.POINT;
    }

    @Override
    public PointFeatureCollection subset(LatLonRect boundingBox, DateRange dateRange) throws IOException {
        return new PointCollectionSubset(this, boundingBox, dateRange);
    }

    protected class PointCollectionSubset
    extends PointCollectionImpl {
        protected PointCollectionImpl from;

        public PointCollectionSubset(PointCollectionImpl from, LatLonRect filter_bb, DateRange filter_date) {
            super(from.name);
            this.from = from;
            if (filter_bb == null) {
                this.boundingBox = from.boundingBox;
            } else {
                LatLonRect latLonRect = this.boundingBox = from.boundingBox == null ? filter_bb : from.boundingBox.intersect(filter_bb);
            }
            this.dateRange = filter_date == null ? from.dateRange : (from.dateRange == null ? filter_date : from.dateRange.intersect(filter_date));
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            return new PointIteratorFiltered(this.from.getPointFeatureIterator(bufferSize), this.boundingBox, this.dateRange);
        }
    }
}

