/*
 * Decompiled with CFR 0.152.
 */
package com.rmemoria.datastream.impl;

import com.rmemoria.datastream.CustomPropertiesReader;
import com.rmemoria.datastream.DataConverter;
import com.rmemoria.datastream.DataMarshaller;
import com.rmemoria.datastream.DataStreamException;
import com.rmemoria.datastream.ObjectProvider;
import com.rmemoria.datastream.impl.ClassMetaData;
import com.rmemoria.datastream.impl.CollectionMetaData;
import com.rmemoria.datastream.impl.PropertyMetaData;
import com.rmemoria.datastream.impl.StreamContextImpl;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XmlDataMarshallerImpl
implements DataMarshaller {
    private StreamContextImpl context;
    private XMLStreamWriter xml;
    private Set<CustomPropertiesReader> propReaders;

    public XmlDataMarshallerImpl(StreamContextImpl context) {
        this.context = context;
    }

    @Override
    public void marshall(Object obj, OutputStream out) {
        this.startMarshall(out);
        try {
            if (obj instanceof Collection) {
                CollectionMetaData colMetaData = this.context.getCollectionMetaData();
                if (colMetaData == null) {
                    throw new DataStreamException("Collection instance was not expected for marshalling");
                }
                this.marshallCollection((Collection)obj, colMetaData);
            } else {
                ClassMetaData cmd = this.context.findClassMetaData(obj);
                if (cmd == null) {
                    throw new DataStreamException("No schema defined for object of class " + obj.getClass().getName());
                }
                this.createXml(obj, cmd, true);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.finishMarshall();
    }

    @Override
    public void marshall(OutputStream output, ObjectProvider provider) {
        this.startMarshall(output);
        try {
            if (this.context.getCollectionMetaData() != null) {
                Object obj;
                CollectionMetaData cmd = this.context.getCollectionMetaData();
                this.xml.writeStartElement(cmd.getObjectCollection().getName());
                int index = 0;
                while ((obj = provider.getObjectToSerialize(index)) != null) {
                    ClassMetaData meta = this.getClassMetadata(obj);
                    this.createXml(obj, meta, true);
                    ++index;
                }
                this.xml.writeEndElement();
            } else {
                Object obj = provider.getObjectToSerialize(0);
                ClassMetaData cmd = this.getClassMetadata(obj);
                this.createXml(obj, cmd, true);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.finishMarshall();
    }

    private ClassMetaData getClassMetadata(Object object) {
        ClassMetaData cmd = this.context.findClassMetaData(object);
        if (cmd == null) {
            throw new IllegalArgumentException("No schema defined for object of class " + object.getClass().getName());
        }
        return cmd;
    }

    protected void startMarshall(OutputStream out) {
        try {
            if (this.xml != null) {
                this.finishMarshall();
            }
            this.xml = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
            this.xml.writeStartDocument();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void marshallCollection(Collection lst, CollectionMetaData meta) throws XMLStreamException {
        this.xml.writeStartElement(meta.getObjectCollection().getName());
        for (Object item : lst) {
            ClassMetaData cmd = this.context.findClassMetaData(item);
            if (cmd == null) {
                throw new IllegalArgumentException("Class not defined to be serialized: " + item.getClass().getName());
            }
            this.createXml(item, cmd, true);
        }
        this.xml.writeEndElement();
    }

    protected void createXml(Object obj, ClassMetaData cmd, boolean includeClassElement) throws XMLStreamException {
        String text;
        Object value;
        if (includeClassElement) {
            this.xml.writeStartElement(cmd.getGraph().getName());
        }
        List<PropertyMetaData> props = cmd.getEndPointProperties();
        for (PropertyMetaData prop : props) {
            if (prop.isSerializationIgnored() || !prop.isXmlAttribute() || (value = prop.getValue(obj)) == null && !prop.isIncludeNullValues() || (text = this.convertToString(value)) == null) continue;
            this.xml.writeAttribute(prop.getElementName(), text);
        }
        for (PropertyMetaData prop : props) {
            if (prop.isSerializationIgnored() || prop.isXmlAttribute() || (value = prop.getValue(obj)) == null && !prop.isIncludeNullValues()) continue;
            this.xml.writeStartElement(prop.getElementName());
            if (value != null) {
                if (prop.getCompactibleTypeMetaData() != null) {
                    if (prop.isCollection()) {
                        Collection lst = (Collection)value;
                        for (Object item : lst) {
                            this.createXml(item, prop.getCompactibleTypeMetaData(), true);
                        }
                    } else {
                        this.createXml(value, prop.getCompactibleTypeMetaData(), false);
                    }
                } else {
                    text = this.convertToString(value);
                    if (text != null) {
                        this.xml.writeCharacters(text);
                    }
                }
            }
            this.xml.writeEndElement();
        }
        this.handleCustomProperties(obj, cmd);
        if (includeClassElement) {
            this.xml.writeEndElement();
        }
    }

    protected void handleCustomProperties(Object obj, ClassMetaData cmd) throws XMLStreamException {
        String node = cmd.getGraph().getCustomPropertiesNode();
        if (node == null) {
            return;
        }
        Map<String, Object> props = this.getCustomProperties(obj);
        if (props == null) {
            return;
        }
        this.xml.writeStartElement(node);
        for (String propname : props.keySet()) {
            Object value = props.get(propname);
            if (value == null) continue;
            this.xml.writeStartElement(propname);
            String text = this.convertToString(value);
            if (text != null) {
                this.xml.writeCharacters(text);
            }
            this.xml.writeEndElement();
        }
        this.xml.writeEndElement();
    }

    protected Map<String, Object> getCustomProperties(Object object) {
        if (this.propReaders == null) {
            return null;
        }
        Map<String, Object> customProps = null;
        for (CustomPropertiesReader propReader : this.propReaders) {
            Map<String, Object> values = propReader.readCustomProperties(object);
            if (customProps == null) {
                customProps = values;
                continue;
            }
            customProps.putAll(values);
        }
        return customProps;
    }

    public void finishMarshall() {
        if (this.xml == null) {
            throw new DataStreamException("Object marshall must be initialized before being finished");
        }
        try {
            this.xml.writeEndDocument();
            this.xml.flush();
            this.xml = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String convertToString(Object value) {
        if (value == null) {
            return "";
        }
        DataConverter conv = this.context.findConverter(value.getClass());
        return conv.convertToString(value);
    }

    @Override
    public void addPropertyReader(CustomPropertiesReader reader) {
        if (this.propReaders == null) {
            this.propReaders = new HashSet<CustomPropertiesReader>();
        }
        this.propReaders.add(reader);
    }

    @Override
    public void removePropertyReader(CustomPropertiesReader reader) {
        if (this.propReaders == null) {
            return;
        }
        this.propReaders.remove(reader);
    }
}

