/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.util.List;
import liquibase.change.Change;
import liquibase.change.core.TagDatabaseChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.core.InsertStatement;
import liquibase.statement.core.MarkChangeSetRanStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkChangeSetRanGenerator
extends AbstractSqlGenerator<MarkChangeSetRanStatement> {
    @Override
    public ValidationErrors validate(MarkChangeSetRanStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("changeSet", statement.getChangeSet());
        return validationErrors;
    }

    @Override
    public Sql[] generateSql(MarkChangeSetRanStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        AbstractSqlStatement runStatement;
        String dateValue = database.getCurrentDateTimeFunction();
        ChangeSet changeSet = statement.getChangeSet();
        try {
            if (statement.getExecType().equals((Object)ChangeSet.ExecType.FAILED) || statement.getExecType().equals((Object)ChangeSet.ExecType.SKIPPED)) {
                return new Sql[0];
            }
            if (statement.getExecType().ranBefore) {
                runStatement = new UpdateStatement(database.getLiquibaseSchemaName(), database.getDatabaseChangeLogTableName()).addNewColumnValue("DATEEXECUTED", new DatabaseFunction(dateValue)).addNewColumnValue("MD5SUM", changeSet.generateCheckSum().toString()).addNewColumnValue("EXECTYPE", statement.getExecType().value).setWhereClause("ID=? AND AUTHOR=? AND FILENAME=?").addWhereParameters(changeSet.getId(), changeSet.getAuthor(), changeSet.getFilePath());
            } else {
                Change change;
                runStatement = new InsertStatement(database.getLiquibaseSchemaName(), database.getDatabaseChangeLogTableName()).addColumnValue("ID", changeSet.getId()).addColumnValue("AUTHOR", changeSet.getAuthor()).addColumnValue("FILENAME", changeSet.getFilePath()).addColumnValue("DATEEXECUTED", new DatabaseFunction(dateValue)).addColumnValue("ORDEREXECUTED", database.getNextChangeSetSequenceValue()).addColumnValue("MD5SUM", changeSet.generateCheckSum().toString()).addColumnValue("DESCRIPTION", this.limitSize(changeSet.getDescription())).addColumnValue("COMMENTS", this.limitSize(StringUtils.trimToEmpty(changeSet.getComments()))).addColumnValue("EXECTYPE", statement.getExecType().value).addColumnValue("LIQUIBASE", LiquibaseUtil.getBuildVersion().replaceAll("SNAPSHOT", "SNP"));
                String tag = null;
                List<Change> changes = changeSet.getChanges();
                if (changes != null && changes.size() == 1 && (change = changes.get(0)) instanceof TagDatabaseChange) {
                    TagDatabaseChange tagChange = (TagDatabaseChange)change;
                    tag = tagChange.getTag();
                }
                if (tag != null) {
                    ((InsertStatement)runStatement).addColumnValue("TAG", tag);
                }
            }
        }
        catch (LiquibaseException e) {
            throw new UnexpectedLiquibaseException(e);
        }
        return SqlGeneratorFactory.getInstance().generateSql(runStatement, database);
    }

    private String limitSize(String string) {
        int maxLength = 255;
        if (string.length() > maxLength) {
            return string.substring(0, maxLength - 3) + "...";
        }
        return string;
    }
}

