/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleGroup
implements Group,
Serializable {
    private static final long serialVersionUID = 5766373925836425908L;
    private String name;
    private Set<Principal> members = new HashSet<Principal>();

    public SimpleGroup(String name) {
        this.name = name;
    }

    public boolean addMember(Principal user) {
        return this.members.add(user);
    }

    public boolean isMember(Principal member) {
        if (this.members.contains(member)) {
            return true;
        }
        for (Principal m : this.members) {
            if (!(m instanceof Group) || !((Group)m).isMember(member)) continue;
            return true;
        }
        return false;
    }

    public Enumeration<? extends Principal> members() {
        return Collections.enumeration(this.members);
    }

    public boolean removeMember(Principal user) {
        return this.members.remove(user);
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleGroup) {
            SimpleGroup other = (SimpleGroup)obj;
            return other.name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

