/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

public final class HttpReplyHdr {
    private static final String CR = "\r\n";
    private static final String HTTP_PROTOCOL = "HTTP/1.0";
    private static final String HTTP_SERVER = "Java Proxy Server";

    private HttpReplyHdr() {
    }

    public static String formOk(String contentType, long contentLength) {
        StringBuilder out = new StringBuilder();
        out.append(HTTP_PROTOCOL).append(" 200 Ok").append(CR);
        out.append("Server: ").append(HTTP_SERVER).append(CR);
        out.append("MIME-version: 1.0").append(CR);
        if (0 < contentType.length()) {
            out.append("Content-Type: ").append(contentType).append(CR);
        } else {
            out.append("Content-Type: text/html").append(CR);
        }
        if (0L != contentLength) {
            out.append("Content-Length: ").append(contentLength).append(CR);
        }
        out.append(CR);
        return out.toString();
    }

    private static String formErrorBody(String error, String description) {
        StringBuilder out = new StringBuilder();
        out.append("<HTML><HEAD><TITLE>");
        out.append(error);
        out.append("</TITLE></HEAD>");
        out.append("<BODY><H2>").append(error).append("</H2>\n");
        out.append("</P></H3>");
        out.append(description);
        out.append("</BODY></HTML>");
        return out.toString();
    }

    private static String formError(String error, String description) {
        String body = HttpReplyHdr.formErrorBody(error, description);
        StringBuilder header = new StringBuilder();
        header.append(HTTP_PROTOCOL).append(" ").append(error).append(CR);
        header.append("Server: ").append(HTTP_SERVER).append(CR);
        header.append("MIME-version: 1.0").append(CR);
        header.append("Content-Type: text/html").append(CR);
        header.append("Content-Length: ").append(body.length()).append(CR);
        header.append(CR);
        header.append(body);
        return header.toString();
    }

    public static String formCreated() {
        return HttpReplyHdr.formError("201 Created", "Object was created");
    }

    public static String formAccepted() {
        return HttpReplyHdr.formError("202 Accepted", "Object checked in");
    }

    public static String formPartial() {
        return HttpReplyHdr.formError("203 Partial", "Only partail document available");
    }

    public static String formMoved() {
        return HttpReplyHdr.formError("301 Moved", "File has moved");
    }

    public static String formFound() {
        return HttpReplyHdr.formError("302 Found", "Object was found");
    }

    public static String formMethod() {
        return HttpReplyHdr.formError("303 Method unseported", "Method unseported");
    }

    public static String formNotModified() {
        return HttpReplyHdr.formError("304 Not modified", "Use local copy");
    }

    public static String formUnauthorized() {
        return HttpReplyHdr.formError("401 Unathorized", "Unathorized use of this service");
    }

    public static String formPaymentNeeded() {
        return HttpReplyHdr.formError("402 Payment required", "Payment is required");
    }

    public static String formForbidden() {
        return HttpReplyHdr.formError("403 Forbidden", "You need permission for this service");
    }

    public static String formNotFound() {
        return HttpReplyHdr.formError("404 Not_found", "Requested object was not found");
    }

    public static String formInternalError() {
        return HttpReplyHdr.formError("500 Internal server error", "Server broke");
    }

    public static String formNotImplemented() {
        return HttpReplyHdr.formError("501 Method not implemented", "Service not implemented");
    }

    public static String formNotImplemented(String reason) {
        return HttpReplyHdr.formError("501 Method not implemented", "Service not implemented. " + reason);
    }

    public static String formOverloaded() {
        return HttpReplyHdr.formError("502 Server overloaded", "Try again latter");
    }

    public static String formTimeout() {
        return HttpReplyHdr.formError("503 Gateway timeout", "The connection timed out");
    }

    public static String formServerNotFound() {
        return HttpReplyHdr.formError("503 Gateway timeout", "The requested server was not found");
    }

    public static String formNotAllowed() {
        return HttpReplyHdr.formError("403 Access Denied", "Access is not allowed");
    }
}

