/*
 * Decompiled with CFR 0.152.
 */
package com.rmemoria.datastream.impl;

import com.rmemoria.datastream.DataStreamException;
import com.rmemoria.datastream.StreamContext;
import com.rmemoria.datastream.impl.ClassMetaData;
import com.rmemoria.datastream.impl.FieldAccess;
import com.rmemoria.datastream.jaxb.Property;
import com.rmemoria.datastream.jaxb.PropertyUse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class PropertyMetaData {
    private PropertyMetaData parent;
    private ClassMetaData classMetaData;
    private Property property;
    private FieldAccess fieldAccess;
    private ClassMetaData typeMetaData;
    private ClassMetaData compactibleTypeMetaData;
    private boolean compactibleTypeChecked = false;
    private List<PropertyMetaData> properties;

    public PropertyMetaData(ClassMetaData classMetaData) {
        this.classMetaData = classMetaData;
    }

    public List<PropertyMetaData> getProperties() {
        return this.properties;
    }

    public void findEndpointProperties(List<PropertyMetaData> props) {
        if (this.properties == null) {
            props.add(this);
            return;
        }
        for (PropertyMetaData pmd : this.properties) {
            pmd.findEndpointProperties(props);
        }
    }

    public String getElementName() {
        if (this.property != null) {
            String elem = this.property.getElementName();
            if (elem == null) {
                return this.property.getName();
            }
            return elem;
        }
        return this.fieldAccess.getName();
    }

    public PropertyMetaData findPropertyByName(String name) {
        if (this.properties == null) {
            return null;
        }
        for (PropertyMetaData pmd : this.properties) {
            if (!pmd.getPropertyName().equals(name)) continue;
            return pmd;
        }
        return null;
    }

    public String getPath() {
        String s = this.getPropertyName();
        if (this.parent != null) {
            s = this.parent.getPath() + "." + s;
        }
        return s;
    }

    public String getPath(PropertyMetaData parentProp) {
        String s = this.getPropertyName();
        if (this.parent != null && this.parent != parentProp) {
            s = this.parent.getPath(parentProp) + "." + s;
        }
        return s;
    }

    public String getPropertyName() {
        if (this.fieldAccess != null) {
            return this.fieldAccess.getName();
        }
        return this.property != null ? this.property.getName() : null;
    }

    public Class<?> getPropertyType() {
        return this.fieldAccess.getFieldType();
    }

    protected void addProperty(PropertyMetaData prop) {
        if (this.properties == null) {
            this.properties = new ArrayList<PropertyMetaData>();
        }
        this.properties.add(prop);
        prop.setParent(this);
    }

    protected void setParent(PropertyMetaData parent) {
        this.parent = parent;
    }

    private Object getFieldAccessObject(StreamContext context, FieldAccess fa, Object obj, String propname, Object propvalue, boolean forcePropValue) {
        Object value;
        Object currentValue = fa.getValue(obj);
        if (currentValue != null && forcePropValue) {
            return currentValue;
        }
        if (currentValue != null && currentValue instanceof Collection) {
            return currentValue;
        }
        Class<?> type = fa.getFieldType();
        HashMap<String, Object> params = null;
        if (propvalue != null) {
            params = new HashMap<String, Object>();
            params.put(propname, propvalue);
        }
        if ((value = context.createInstance(type, params)) != currentValue) {
            fa.setValue(obj, value);
        }
        return value;
    }

    public ClassMetaData getCompactibleTypeMetaData() {
        if (this.typeMetaData != null) {
            return this.typeMetaData;
        }
        if (this.compactibleTypeMetaData == null && !this.compactibleTypeChecked) {
            this.compactibleTypeMetaData = this.getClassMetaData().getContext().findClassMetaDataByClass(this.getConvertionType());
        }
        return this.compactibleTypeMetaData;
    }

    public Class getConvertionType() {
        return this.fieldAccess.getFieldType();
    }

    public boolean isSerializationIgnored() {
        if (this.isIgnored()) {
            return true;
        }
        String s = this.getPropertyName();
        return s.equals(this.classMetaData.getGraph().getParentProperty());
    }

    public boolean isXmlAttribute() {
        return this.property != null && this.property.isXmlAttribute();
    }

    public boolean isComposed() {
        return this.properties != null;
    }

    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.getConvertionType());
    }

    public Collection getCollectionObject(StreamContext context, Object obj) {
        Object value = this.getFieldAccessObject(context, this.fieldAccess, obj, null, null, false);
        return (Collection)value;
    }

    public boolean isIncludeNullValues() {
        return this.property != null && this.property.getIncludeNullValues() != null ? this.property.getIncludeNullValues().booleanValue() : this.getClassMetaData().getGraph().isIncludeNullValues();
    }

    public boolean isIgnored() {
        if (this.property != null) {
            return this.property.getUse() == PropertyUse.IGNORE;
        }
        return this.classMetaData.isNotDeclaredPropsIgnored();
    }

    public Object getValue(Object obj) {
        if (this.parent == null) {
            return this.fieldAccess.getValue(obj);
        }
        ArrayList<PropertyMetaData> props = new ArrayList<PropertyMetaData>();
        for (PropertyMetaData p = this; p != null; p = p.getParent()) {
            props.add(p);
        }
        Object val = obj;
        for (int i = props.size() - 1; i >= 0; --i) {
            FieldAccess fa = ((PropertyMetaData)props.get(i)).getFieldAccess();
            if (fa == null) {
                throw new DataStreamException("Not possible to access field " + this.getPropertyName());
            }
            if ((val = fa.getValue(val)) != null) continue;
            return null;
        }
        return val;
    }

    public String toString() {
        return this.classMetaData.getGraph().getClazz() + "." + this.getPath();
    }

    public Property getProperty() {
        return this.property;
    }

    public void setProperty(Property property) {
        this.property = property;
    }

    public ClassMetaData getClassMetaData() {
        return this.classMetaData;
    }

    public FieldAccess getFieldAccess() {
        return this.fieldAccess;
    }

    public void setFieldAccess(FieldAccess field) {
        this.fieldAccess = field;
    }

    public ClassMetaData getTypeMetaData() {
        return this.typeMetaData;
    }

    public void setTypeMetaData(ClassMetaData typeMetaData) {
        this.typeMetaData = typeMetaData;
    }

    public PropertyMetaData getParent() {
        return this.parent;
    }
}

