/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.AbstractProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;

public abstract class MultiProperty
extends AbstractProperty {
    private static final long serialVersionUID = 240L;

    public MultiProperty() {
    }

    public MultiProperty(String name) {
        super(name);
    }

    public abstract PropertyIterator iterator();

    public abstract void addProperty(JMeterProperty var1);

    public abstract void clear();

    @Override
    public void setRunningVersion(boolean running) {
        super.setRunningVersion(running);
        PropertyIterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next().setRunningVersion(running);
        }
    }

    protected void recoverRunningVersionOfSubElements(TestElement owner) {
        PropertyIterator iter = this.iterator();
        while (iter.hasNext()) {
            JMeterProperty prop = iter.next();
            if (owner.isTemporary(prop)) {
                iter.remove();
                continue;
            }
            prop.recoverRunningVersion(owner);
        }
    }

    @Override
    public void mergeIn(JMeterProperty prop) {
        if (prop.getObjectValue() == this.getObjectValue()) {
            return;
        }
        log.debug("merging in " + prop.getClass());
        if (prop instanceof MultiProperty) {
            PropertyIterator iter = ((MultiProperty)prop).iterator();
            while (iter.hasNext()) {
                JMeterProperty item = iter.next();
                this.addProperty(item);
            }
        } else {
            this.addProperty(prop);
        }
    }
}

