/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.testcase;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.apache.avalon.excalibur.component.DefaultRoleManager;
import org.apache.avalon.excalibur.component.ExcaliburComponentManager;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.logger.DefaultLogKitManager;
import org.apache.avalon.excalibur.logger.LogKitManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.io.StreamTarget;

public class ExcaliburTestCase
extends TestCase {
    private static final String FORMAT = "%7.7{priority} %23.23{time:yyyy-MM-dd' 'HH:mm:ss.SSS} [%30.30{category}] (%{context}): %{message}\n%{throwable}";
    private Logger m_logger;
    private LogKitLogger m_logEnabledLogger;
    private ExcaliburComponentManager m_manager;
    private DefaultLogKitManager m_logKitManager;
    private static HashMap m_tests = new HashMap();
    protected ComponentManager manager;

    public ExcaliburTestCase(String name) {
        super(name);
        ArrayList<String> methodList = (ArrayList<String>)m_tests.get(((Object)((Object)this)).getClass());
        if (null == methodList) {
            Method[] methods = ((Object)((Object)this)).getClass().getMethods();
            methodList = new ArrayList<String>(methods.length);
            for (int i = 0; i < methods.length; ++i) {
                String methodName = methods[i].getName();
                if (!methodName.startsWith("test") || !Modifier.isPublic(methods[i].getModifiers()) || !methods[i].getReturnType().equals(Void.TYPE) || methods[i].getParameterTypes().length != 0) continue;
                methodList.add(methodName);
            }
            m_tests.put(((Object)((Object)this)).getClass(), methodList);
        }
    }

    protected Logger getLogger() {
        return this.m_logger;
    }

    protected LogKitLogger getLogEnabledLogger() {
        return this.m_logEnabledLogger;
    }

    protected void prepare() throws Exception {
        String resourceName = ((Object)((Object)this)).getClass().getName().replace('.', '/') + ".xtest";
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourceName);
        if (resource != null) {
            this.getLogger().debug("Loading resource " + resourceName);
            this.prepare(resource.openStream());
        } else {
            this.getLogger().debug("Resource not found " + resourceName);
        }
    }

    protected final void prepare(InputStream testconf) throws Exception {
        this.getLogger().debug("ExcaliburTestCase.initialize");
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        Configuration conf = builder.build(testconf);
        String annotation = conf.getChild("annotation").getValue(null);
        if (null != annotation && !"".equals(annotation)) {
            this.m_logger.info(annotation);
        }
        Context context = this.setupContext(conf.getChild("context"));
        this.setupManagers(conf.getChild("components"), conf.getChild("roles"), conf.getChild("logkit"), context);
        this.manager = this.m_manager;
        this.setCurrentLogger("prepare");
    }

    private final void done() {
        if (null != this.m_manager) {
            this.m_manager.dispose();
        }
        this.m_manager = null;
    }

    private String getBaseClassName(Class clazz) {
        String name = clazz.getName();
        int pos = name.lastIndexOf(46);
        if (pos >= 0) {
            name = name.substring(pos + 1);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void run(TestResult result) {
        ArrayList methodList;
        block15: {
            methodList = (ArrayList)m_tests.get(((Object)((Object)this)).getClass());
            if (null == methodList || methodList.isEmpty()) {
                return;
            }
            this.setCurrentLogger(this.getBaseClassName(((Object)((Object)this)).getClass()));
            try {
                if (this instanceof Initializable) {
                    ((Initializable)this).initialize();
                }
                this.prepare();
                Iterator tests = methodList.iterator();
                while (tests.hasNext()) {
                    String methodName = (String)tests.next();
                    this.setName(methodName);
                    this.setCurrentLogger(methodName);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("");
                        this.getLogger().debug("========================================");
                        this.getLogger().debug("  begin test: " + methodName);
                        this.getLogger().debug("========================================");
                    }
                    super.run(result);
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("========================================");
                    this.getLogger().debug("  end test: " + methodName);
                    this.getLogger().debug("========================================");
                    this.getLogger().debug("");
                }
                Object var6_6 = null;
                this.done();
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.done();
                if (this instanceof Disposable) {
                    try {
                        ((Disposable)this).dispose();
                    }
                    catch (Exception e2) {
                        result.addFailure((Test)this, new AssertionFailedError("Disposal Error"));
                    }
                }
                throw throwable;
            }
            if (this instanceof Disposable) {
                try {
                    ((Disposable)this).dispose();
                }
                catch (Exception e2) {
                    result.addFailure((Test)this, new AssertionFailedError("Disposal Error"));
                }
            }
            break block15;
            {
                catch (Exception e) {
                    System.out.println(e);
                    e.printStackTrace();
                    result.addError((Test)this, (Throwable)e);
                    Object var6_7 = null;
                    this.done();
                    if (this instanceof Disposable) {
                        try {
                            ((Disposable)this).dispose();
                        }
                        catch (Exception e2) {
                            result.addFailure((Test)this, new AssertionFailedError("Disposal Error"));
                        }
                    }
                }
            }
        }
        methodList.clear();
        m_tests.put(((Object)((Object)this)).getClass(), methodList);
    }

    private final void setCurrentLogger(String name) {
        Logger logger;
        if (this.m_logKitManager == null) {
            logger = Hierarchy.getDefaultHierarchy().getLoggerFor(name);
            logger.setPriority(Priority.INFO);
            PatternFormatter formatter = new PatternFormatter(FORMAT);
            StreamTarget target = new StreamTarget((OutputStream)System.out, (Formatter)formatter);
            logger.setLogTargets(new LogTarget[]{target});
        } else {
            logger = this.m_logKitManager.getLogger("test." + name);
        }
        this.m_logger = logger;
        this.m_logEnabledLogger = new LogKitLogger(this.m_logger);
    }

    private final Context setupContext(Configuration conf) throws Exception {
        DefaultContext context = new DefaultContext();
        Configuration[] confs = conf.getChildren("entry");
        for (int i = 0; i < confs.length; ++i) {
            String key = confs[i].getAttribute("name");
            String value = confs[i].getAttribute("value", null);
            if (value == null) {
                String clazz = confs[i].getAttribute("class");
                Object obj = ((Object)((Object)this)).getClass().getClassLoader().loadClass(clazz).newInstance();
                context.put((Object)key, obj);
                if (!this.getLogger().isInfoEnabled()) continue;
                this.getLogger().info("ExcaliburTestCase: added an instance of class " + clazz + " to context entry " + key);
                continue;
            }
            context.put((Object)key, (Object)value);
            if (!this.getLogger().isInfoEnabled()) continue;
            this.getLogger().info("ExcaliburTestCase: added value \"" + value + "\" to context entry " + key);
        }
        this.addContext(context);
        return context;
    }

    protected void addContext(DefaultContext context) {
    }

    private final void setupManagers(Configuration confCM, Configuration confRM, Configuration confLM, Context context) throws Exception {
        String lmLoggerName = confLM.getAttribute("logger", "lm");
        String lmLogLevel = confLM.getAttribute("log-level", "INFO");
        Priority lmPriority = Priority.getPriorityForName((String)lmLogLevel);
        DefaultLogKitManager logKitManager = new DefaultLogKitManager();
        Logger lmLogger = Hierarchy.getDefaultHierarchy().getLoggerFor(lmLoggerName);
        lmLogger.setPriority(lmPriority);
        logKitManager.enableLogging((org.apache.avalon.framework.logger.Logger)new LogKitLogger(lmLogger));
        logKitManager.contextualize(context);
        logKitManager.configure(confLM);
        Hierarchy h = logKitManager.getHierarchy();
        h.setDefaultPriority(lmPriority);
        this.m_logKitManager = logKitManager;
        String rmLoggerName = confRM.getAttribute("logger", "rm");
        DefaultRoleManager roleManager = new DefaultRoleManager();
        roleManager.setLogger(logKitManager.getLogger(rmLoggerName));
        roleManager.configure(confRM);
        String cmLoggerName = confCM.getAttribute("logger", "cm");
        ExcaliburComponentManager ecManager = new ExcaliburComponentManager();
        ecManager.setLogger(logKitManager.getLogger(cmLoggerName));
        ecManager.setLogKitManager((LogKitManager)logKitManager);
        ecManager.contextualize(context);
        ecManager.setRoleManager((RoleManager)roleManager);
        ecManager.configure(confCM);
        ecManager.initialize();
        this.m_manager = ecManager;
    }

    protected final Object lookup(String key) throws ComponentException {
        return this.manager.lookup(key);
    }

    protected final void release(Component object) {
        this.manager.release(object);
    }
}

