/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.resteasy;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.plugins.server.servlet.HttpServletInputMessage;
import org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper;
import org.jboss.resteasy.plugins.server.servlet.ServletSecurityContext;
import org.jboss.resteasy.plugins.server.servlet.ServletUtil;
import org.jboss.resteasy.specimpl.UriInfoImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.log.Log;
import org.jboss.seam.resteasy.Application;
import org.jboss.seam.resteasy.SeamResteasyProviderFactory;
import org.jboss.seam.servlet.ContextualHttpServletRequest;
import org.jboss.seam.web.AbstractResource;
import org.jboss.seam.web.Session;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.resteasy.resourceAdapter")
@BypassInterceptors
@Install(precedence=0)
public class ResteasyResourceAdapter
extends AbstractResource {
    @Logger
    Log log;
    protected Dispatcher dispatcher;
    protected Application application;

    @Create
    public void init() {
        this.dispatcher = (Dispatcher)Component.getInstance((String)"org.jboss.seam.resteasy.dispatcher");
        this.application = (Application)((Object)Component.getInstance(Application.class));
        if (this.dispatcher == null) {
            throw new IllegalStateException("ReasteasyDispatcher not available, make sure RESTEasy and all required JARs are on your classpath");
        }
    }

    public String getResourcePath() {
        return this.application.getResourcePathPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getResource(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        try {
            this.log.debug((Object)"processing REST request", new Object[0]);
            ThreadLocalResteasyProviderFactory.push((ResteasyProviderFactory)this.dispatcher.getProviderFactory());
            SeamResteasyProviderFactory.pushContext(HttpServletRequest.class, (Object)request);
            SeamResteasyProviderFactory.pushContext(HttpServletResponse.class, (Object)response);
            SeamResteasyProviderFactory.pushContext(SecurityContext.class, (Object)new ServletSecurityContext(request));
            new ContextualHttpServletRequest(request){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process() throws ServletException, IOException {
                    try {
                        HttpHeaders headers = ServletUtil.extractHttpHeaders((HttpServletRequest)request);
                        UriInfoImpl uriInfo = ResteasyResourceAdapter.this.extractUriInfo(request, ResteasyResourceAdapter.this.application.getResourcePathPrefix());
                        HttpServletResponseWrapper theResponse = new HttpServletResponseWrapper(response, ResteasyResourceAdapter.this.dispatcher.getProviderFactory());
                        HttpServletInputMessage in = new HttpServletInputMessage(request, (HttpResponse)theResponse, headers, (UriInfo)uriInfo, request.getMethod().toUpperCase(), (SynchronousDispatcher)ResteasyResourceAdapter.this.dispatcher);
                        ResteasyResourceAdapter.this.dispatcher.invoke((HttpRequest)in, (HttpResponse)theResponse);
                    }
                    finally {
                        if (ResteasyResourceAdapter.this.application.isDestroySessionAfterRequest()) {
                            ResteasyResourceAdapter.this.log.debug((Object)"Destroying HttpSession after REST request", new Object[0]);
                            Session.instance().invalidate();
                        }
                    }
                }
            }.run();
        }
        finally {
            SeamResteasyProviderFactory.clearContextData();
            ThreadLocalResteasyProviderFactory.pop();
            this.log.debug((Object)"completed processing of REST request", new Object[0]);
        }
    }

    protected UriInfoImpl extractUriInfo(HttpServletRequest request, String pathPrefix) {
        try {
            if (!pathPrefix.startsWith("/")) {
                pathPrefix = "/" + pathPrefix;
            }
            URL requestURL = new URL(request.getRequestURL().toString());
            String requestPath = requestURL.getPath();
            String mappingPrefix = requestPath.substring(0, requestPath.indexOf(pathPrefix) + pathPrefix.length());
            mappingPrefix = mappingPrefix.substring(request.getContextPath().length());
            this.log.debug((Object)("Using request mapping prefix: " + mappingPrefix), new Object[0]);
            return ServletUtil.extractUriInfo((HttpServletRequest)request, (String)mappingPrefix);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

