/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.nonAxisChart;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import org.jCharts.Chart;
import org.jCharts.chartData.interfaces.IPieChartDataSet;
import org.jCharts.chartData.processors.PieChartDataProcessor;
import org.jCharts.chartText.NumericTagGroup;
import org.jCharts.chartText.TextTagGroup;
import org.jCharts.imageMap.CircleMapArea;
import org.jCharts.imageMap.ImageMap;
import org.jCharts.imageMap.PolyMapArea;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.properties.PieChart2DProperties;
import org.jCharts.test.HTMLChartTestable;
import org.jCharts.test.HTMLGenerator;
import org.jCharts.types.PieLabelType;

public final class PieChart2D
extends Chart
implements HTMLChartTestable {
    private float pieX;
    private float pieY;
    private float diameter;
    private IPieChartDataSet iPieChartDataSet;
    private PieChartDataProcessor pieChartDataProcessor;
    private TextTagGroup textTagGroup;

    public PieChart2D(IPieChartDataSet iPieChartDataSet, LegendProperties legendProperties, ChartProperties chartProperties, int n, int n2) {
        super(legendProperties, chartProperties, n, n2);
        this.iPieChartDataSet = iPieChartDataSet;
    }

    protected void renderChart() {
        float f;
        PieChart2DProperties pieChart2DProperties = (PieChart2DProperties)this.iPieChartDataSet.getChartTypeProperties();
        this.pieChartDataProcessor = new PieChartDataProcessor(this.iPieChartDataSet);
        this.pieChartDataProcessor.processData();
        float f2 = super.getChartProperties().getEdgePadding() * 2.0f;
        float f3 = super.getImageWidth() / 2;
        float f4 = super.getImageHeight() / 2;
        FontRenderContext fontRenderContext = super.getGraphics2D().getFontRenderContext();
        float f5 = super.renderChartTitle(this.iPieChartDataSet.getChartTitle(), fontRenderContext);
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        if (!pieChart2DProperties.getPieLabelType().equals(PieLabelType.NO_LABELS)) {
            int n;
            if (pieChart2DProperties.getPieLabelType().equals(PieLabelType.VALUE_LABELS)) {
                this.textTagGroup = new NumericTagGroup(pieChart2DProperties.getValueLabelFont(), fontRenderContext, pieChart2DProperties.showValueLabelCurrency(), false, pieChart2DProperties.showValueLabelGrouping(), pieChart2DProperties.getValueLabelRoundingPowerOfTen());
                n = 0;
                while (n < this.iPieChartDataSet.getNumberOfDataItems()) {
                    ((NumericTagGroup)this.textTagGroup).addLabel(this.iPieChartDataSet.getValue(n));
                    ++n;
                }
            } else {
                this.textTagGroup = new TextTagGroup(pieChart2DProperties.getValueLabelFont(), fontRenderContext);
                n = 0;
                while (n < this.iPieChartDataSet.getNumberOfLegendLabels()) {
                    this.textTagGroup.addLabel(this.iPieChartDataSet.getLegendLabel(n));
                    ++n;
                }
            }
            f6 = this.textTagGroup.getWidestLabel();
            f7 = f6 * 2.0f;
            f8 = this.textTagGroup.getTallestLabel();
            f9 = f8 * 2.0f;
        }
        if (this.getLegend() != null) {
            f = 0.0f;
            float f10 = 0.0f;
            this.getLegend().calculateDrawingValues(this.iPieChartDataSet);
            if (this.getLegend().getLegendProperties().getPlacement() == 1 || this.getLegend().getLegendProperties().getPlacement() == 2) {
                float f11 = this.getLegend().getWidth() + (float)this.getLegend().getLegendProperties().getChartPadding();
                f11 += f2;
                float f12 = super.getImageHeight();
                f12 -= f2;
                f12 -= f5;
                if (this.textTagGroup != null) {
                    f11 += f7;
                    f11 += pieChart2DProperties.getTickLength() * 2.0f;
                    f12 -= f9;
                }
                this.diameter = Math.max((float)super.getImageWidth() - f11, 1.0f);
                this.diameter = Math.min(this.diameter, f12);
                if (this.getLegend().getLegendProperties().getPlacement() == 1) {
                    this.pieX = f3 - (this.getLegend().getWidth() + (float)this.getLegend().getLegendProperties().getChartPadding() + this.diameter) / 2.0f;
                    f = this.pieX + this.diameter + (float)this.getLegend().getLegendProperties().getChartPadding();
                    f += f6;
                    f += pieChart2DProperties.getTickLength();
                } else {
                    f = f3 - (this.getLegend().getWidth() + (float)this.getLegend().getLegendProperties().getChartPadding() + this.diameter) / 2.0f;
                    this.pieX = f + this.getLegend().getWidth() + (float)this.getLegend().getLegendProperties().getChartPadding();
                }
                f10 = f4 - (float)(this.getLegend().getHeight() / 2);
                f10 += f5 / 2.0f;
                this.pieY = f4 - this.diameter / 2.0f;
                this.pieY += f5 / 2.0f;
            } else {
                float f13 = this.getLegend().getHeight() + this.getLegend().getLegendProperties().getChartPadding();
                f13 += f2;
                this.diameter = Math.max((float)super.getImageHeight() - (f13 += f5), 1.0f);
                this.diameter = Math.min(this.diameter, (float)super.getImageWidth() - f2);
                if (this.getLegend().getLegendProperties().getPlacement() == 0) {
                    this.pieY = f4 - ((float)(this.getLegend().getHeight() + this.getLegend().getLegendProperties().getChartPadding()) + this.diameter) / 2.0f;
                    this.pieY += f5 / 2.0f;
                    f10 = this.pieY + this.diameter + (float)this.getLegend().getLegendProperties().getChartPadding();
                } else {
                    f10 = f4 - ((float)(this.getLegend().getHeight() + this.getLegend().getLegendProperties().getChartPadding()) + this.diameter) / 2.0f;
                    this.pieY = (f10 += f5 / 2.0f) + (float)this.getLegend().getHeight() + (float)this.getLegend().getLegendProperties().getChartPadding();
                }
                f = f3 - this.getLegend().getWidth() / 2.0f;
                this.pieX = f3 - this.diameter / 2.0f;
            }
            super.getLegend().setX(f);
            super.getLegend().setY(f10);
            super.getLegend().render();
        } else {
            f = (float)super.getImageHeight() - f2 - f5;
            float f14 = (float)super.getImageWidth() - f2;
            if (this.textTagGroup != null) {
                f14 -= f7;
                f14 -= pieChart2DProperties.getTickLength() * 2.0f;
                f -= f9;
                f -= pieChart2DProperties.getTickLength() * 2.0f;
            }
            this.diameter = Math.min(f, f14);
            float f15 = this.diameter / 2.0f;
            this.pieX = f3 - f15;
            this.pieY = f4 - f15;
            this.pieY += f5 / 2.0f;
        }
        if (super.getGenerateImageMapFlag()) {
            ImageMap imageMap = new ImageMap(this.iPieChartDataSet.getNumberOfDataItems());
            super.setImageMap(imageMap);
        }
        PieChart2D.render(this);
    }

    static void render(PieChart2D pieChart2D) {
        Graphics2D graphics2D = pieChart2D.getGraphics2D();
        PieChart2DProperties pieChart2DProperties = (PieChart2DProperties)pieChart2D.iPieChartDataSet.getChartTypeProperties();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(pieChart2DProperties.getBorderStroke());
        int n = 3;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float[][] fArray = null;
        if (pieChart2D.getImageMap() != null) {
            f = (float)((double)pieChart2D.diameter / 2.0);
            f2 = f + pieChart2D.pieX;
            f3 = f + pieChart2D.pieY;
            fArray = new float[pieChart2D.iPieChartDataSet.getNumberOfDataItems() * (n + 1)][2];
        }
        float f4 = pieChart2DProperties.getZeroDegreeOffset();
        double d = 0.0;
        if (pieChart2D.iPieChartDataSet.getNumberOfDataItems() == 1) {
            Arc2D.Double double_ = new Arc2D.Double(pieChart2D.pieX, pieChart2D.pieY, pieChart2D.diameter, pieChart2D.diameter, f4, 360.0, 0);
            graphics2D.setPaint(pieChart2D.iPieChartDataSet.getPaint(0));
            graphics2D.fill(double_);
            graphics2D.setPaint(pieChart2DProperties.getBorderPaint());
            graphics2D.draw(double_);
            if (pieChart2D.getImageMap() != null) {
                CircleMapArea circleMapArea = new CircleMapArea(f2, f3, pieChart2D.iPieChartDataSet.getValue(0), null, pieChart2D.iPieChartDataSet.getLegendLabel(0));
                circleMapArea.setRadius((int)pieChart2D.diameter);
                pieChart2D.getImageMap().addImageMapArea(circleMapArea);
            }
        } else {
            Arc2D.Double double_ = new Arc2D.Double(pieChart2D.pieX, pieChart2D.pieY, pieChart2D.diameter, pieChart2D.diameter, f4, 360.0, 2);
            int n2 = 0;
            int n3 = 0;
            while (n3 < pieChart2D.iPieChartDataSet.getNumberOfDataItems()) {
                double d2;
                double d3;
                double d4;
                double d5;
                d = pieChart2D.pieChartDataProcessor.getPercentageOfPie(n3);
                double_.setAngleStart(f4);
                double_.setAngleExtent(d);
                graphics2D.setPaint(pieChart2D.iPieChartDataSet.getPaint(n3));
                graphics2D.fill(double_);
                graphics2D.setPaint(pieChart2DProperties.getBorderPaint());
                graphics2D.draw(double_);
                if (pieChart2D.textTagGroup != null) {
                    d5 = (double)f4 + d / 2.0;
                    if (d5 > 360.0) {
                        d5 -= 360.0;
                    }
                    d4 = Math.toRadians(d5);
                    d3 = Math.cos(d4);
                    d2 = Math.sin(d4);
                    f = (float)((double)pieChart2D.diameter / 2.0);
                    float f5 = (float)(d3 * (double)f);
                    float f6 = (float)(-(d2 * (double)f));
                    float f7 = (float)(d3 * (double)(f + pieChart2DProperties.getTickLength()));
                    float f8 = (float)(-(d2 * (double)(f + pieChart2DProperties.getTickLength())));
                    f2 = f + pieChart2D.pieX;
                    f3 = f + pieChart2D.pieY;
                    pieChart2DProperties.getValueLabelFont().setupGraphics2D(graphics2D);
                    graphics2D.draw(new Line2D.Double(f2 + f5, f3 + f6, f2 + f7, f3 + f8));
                    float f9 = f3 + f8;
                    if (d5 > 60.0 && d5 < 120.0) {
                        f9 -= pieChart2D.textTagGroup.getTextTag(n3).getFontDescent();
                    } else if (d5 > 240.0 && d5 < 300.0) {
                        f9 += pieChart2D.textTagGroup.getTextTag(n3).getFontAscent();
                    }
                    if (d5 > 90.0 && d5 < 270.0) {
                        graphics2D.drawString(pieChart2D.textTagGroup.getTextTag(n3).getText(), f2 + f7 - pieChart2D.textTagGroup.getTextTag(n3).getWidth() - pieChart2DProperties.getTickLength(), f9);
                    } else {
                        graphics2D.drawString(pieChart2D.textTagGroup.getTextTag(n3).getText(), f2 + f7 + pieChart2DProperties.getTickLength(), f9);
                    }
                }
                if (pieChart2D.getImageMap() != null) {
                    d5 = f4;
                    d2 = d / (double)n;
                    int n4 = 0;
                    while (n4 <= n) {
                        d4 = Math.cos(Math.toRadians(d5));
                        d3 = Math.sin(Math.toRadians(d5));
                        fArray[n2][0] = f2 + (float)(d4 * (double)f);
                        fArray[n2][1] = f3 + (float)(-(d3 * (double)f));
                        ++n2;
                        d5 += d2;
                        ++n4;
                    }
                }
                f4 = (float)((double)f4 + d);
                ++n3;
            }
            if (pieChart2D.getImageMap() != null) {
                int n5 = 0;
                int n6 = 0;
                while (n6 < pieChart2D.iPieChartDataSet.getNumberOfDataItems()) {
                    int n7 = 0;
                    PolyMapArea polyMapArea = new PolyMapArea(3 + n, pieChart2D.iPieChartDataSet.getValue(n6), null, pieChart2D.iPieChartDataSet.getLegendLabel(n6));
                    polyMapArea.addCoordinate(n7++, f2, f3);
                    int n8 = 0;
                    while (n8 <= n) {
                        polyMapArea.addCoordinate(n7++, fArray[n5][0], fArray[n5][1]);
                        ++n5;
                        ++n8;
                    }
                    if (n6 + 1 == pieChart2D.iPieChartDataSet.getNumberOfDataItems()) {
                        polyMapArea.addCoordinate(n7, fArray[0][0], fArray[0][1]);
                    } else {
                        polyMapArea.addCoordinate(n7, fArray[n5][0], fArray[n5][1]);
                    }
                    pieChart2D.getImageMap().addImageMapArea(polyMapArea);
                    ++n6;
                }
            }
        }
    }

    public void toHTML(HTMLGenerator hTMLGenerator, String string) {
        if (this.getLegend() != null) {
            hTMLGenerator.chartTableRowStart();
            this.getLegend().toHTML(hTMLGenerator);
            hTMLGenerator.chartTableRowEnd();
        }
        hTMLGenerator.chartTableEnd();
    }
}

