/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import org.apache.jmeter.util.JMeterUtils;

public class HeaderAsPropertyRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 240L;
    private Object[][] columnsMsgParameters;

    public HeaderAsPropertyRenderer() {
        this((Object[][])null);
    }

    public HeaderAsPropertyRenderer(Object[][] columnsMsgParameters) {
        this.columnsMsgParameters = columnsMsgParameters;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table != null) {
            JTableHeader header = table.getTableHeader();
            if (header != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            this.setText(this.getText(value, row, column));
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
        }
        return this;
    }

    protected String getText(Object value, int row, int column) {
        if (value == null) {
            return "";
        }
        if (this.columnsMsgParameters != null && this.columnsMsgParameters[column] != null) {
            return MessageFormat.format(JMeterUtils.getResString(value.toString()), this.columnsMsgParameters[column]);
        }
        return JMeterUtils.getResString(value.toString());
    }
}

