/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.search.StringTerm;

public final class HeaderTerm
extends StringTerm {
    protected String headerName;

    public HeaderTerm(String header, String pattern) {
        super(pattern);
        this.headerName = header;
    }

    public boolean equals(Object other) {
        return super.equals(other) && ((HeaderTerm)other).headerName.equals(this.headerName);
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public int hashCode() {
        return super.hashCode() + this.headerName.hashCode();
    }

    public boolean match(Message message) {
        try {
            String[] values = message.getHeader(this.headerName);
            if (values == null || values.length == 0) {
                return false;
            }
            boolean result = false;
            for (int i = 0; !result && i < values.length; ++i) {
                String value = values[i];
                result = this.match(value);
            }
            return result;
        }
        catch (MessagingException e) {
            return false;
        }
    }
}

