/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class Flags
implements Cloneable,
Serializable {
    private static final Flag[] FLAG_ARRAY = new Flag[0];
    private static final String[] STRING_ARRAY = new String[0];
    private Map _map = new HashMap(4);

    public Flags() {
    }

    public Flags(Flag flag) {
        this.add(flag);
    }

    public Flags(Flags flags) {
        this.add(flags);
    }

    public Flags(String name) {
        this.add(name);
    }

    public void add(Flag flag) {
        this._map.put(flag.getName(), flag);
    }

    public void add(Flags flags) {
        this._map.putAll(flags._map);
    }

    public void add(String name) {
        this.add(new Flag(name));
    }

    public Object clone() {
        try {
            Flags clone = (Flags)super.clone();
            clone._map = new HashMap(this._map);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public boolean contains(Flag flag) {
        return this._map.containsKey(flag.getName());
    }

    public boolean contains(Flags flags) {
        Iterator it = flags._map.keySet().iterator();
        boolean result = true;
        while (result && it.hasNext()) {
            result = this._map.containsKey(it.next());
        }
        return result;
    }

    public boolean contains(String name) {
        return this._map.containsKey(name);
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        Flags flags = (Flags)other;
        return ((Object)flags._map).equals(this._map);
    }

    public Flag[] getSystemFlags() {
        LinkedList<Flag> result = new LinkedList<Flag>();
        Iterator it = this._map.values().iterator();
        while (it.hasNext()) {
            Flag flag = (Flag)it.next();
            if (!flag.isSystemFlag()) continue;
            result.add(flag);
        }
        return result.toArray(FLAG_ARRAY);
    }

    public String[] getUserFlags() {
        LinkedList<String> result = new LinkedList<String>();
        Iterator it = this._map.values().iterator();
        while (it.hasNext()) {
            Flag flag = (Flag)it.next();
            if (flag.isSystemFlag()) continue;
            result.add(flag.getName());
        }
        return result.toArray(STRING_ARRAY);
    }

    public int hashCode() {
        return ((Object)this._map.keySet()).hashCode();
    }

    public void remove(Flag flag) {
        this._map.remove(flag.getName());
    }

    public void remove(Flags flags) {
        Iterator it = flags._map.keySet().iterator();
        while (it.hasNext()) {
            this._map.remove(it.next());
        }
    }

    public void remove(String name) {
        this._map.remove(name);
    }

    public String toString() {
        return this._map.keySet().toString();
    }

    public static final class Flag {
        public static final Flag ANSWERED = new Flag("Answered", true);
        public static final Flag DELETED = new Flag("Deleted", true);
        public static final Flag DRAFT = new Flag("Draft", true);
        public static final Flag FLAGGED = new Flag("Flagged", true);
        public static final Flag RECENT = new Flag("Recent", true);
        public static final Flag SEEN = new Flag("Seen", true);
        public static final Flag USER = new Flag("", false);
        private String _name;
        private boolean _system;

        private Flag(String name) {
            this(name, false);
        }

        private Flag(String name, boolean system) {
            if (name == null) {
                throw new IllegalArgumentException("Flag name cannot be null");
            }
            this._name = name;
            this._system = system;
        }

        private String getName() {
            return this._name;
        }

        private boolean isSystemFlag() {
            return this._system;
        }
    }
}

