/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.radial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.radial.Dorade2Dataset;
import ucar.nc2.dt.radial.LevelII2Dataset;
import ucar.nc2.dt.radial.Netcdf2Dataset;
import ucar.nc2.dt.radial.Nids2Dataset;
import ucar.nc2.dt.radial.UF2Dataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactory;
import ucar.nc2.util.CancelTask;

public class RadialDatasetStandardFactory
implements FeatureDatasetFactory {
    private static List<TypedDatasetFactoryIF> factories = new ArrayList<TypedDatasetFactoryIF>(10);

    static void registerFactory(Class c) {
        Object instance;
        if (!TypedDatasetFactoryIF.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class " + c.getName() + " must implement TypedDatasetFactoryIF");
        }
        try {
            instance = c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("FeatureDatasetFactoryManager Class " + c.getName() + " cannot instantiate, probably need default Constructor");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("FeatureDatasetFactoryManager Class " + c.getName() + " is not accessible");
        }
        factories.add((TypedDatasetFactoryIF)instance);
    }

    @Override
    public Object isMine(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) throws IOException {
        if (wantFeatureType != FeatureType.RADIAL && wantFeatureType != FeatureType.NONE && wantFeatureType != FeatureType.ANY) {
            return null;
        }
        for (TypedDatasetFactoryIF fac : factories) {
            if (!fac.isMine(ds)) continue;
            return fac;
        }
        return null;
    }

    @Override
    public FeatureDataset open(FeatureType ftype, NetcdfDataset ncd, Object analysis, CancelTask task, Formatter errlog) throws IOException {
        TypedDatasetFactoryIF fac = (TypedDatasetFactoryIF)analysis;
        StringBuilder sbuff = new StringBuilder();
        TypedDataset result = fac.open(ncd, task, sbuff);
        errlog.format("%s", sbuff);
        return (FeatureDataset)((Object)result);
    }

    @Override
    public FeatureType[] getFeatureType() {
        return new FeatureType[]{FeatureType.RADIAL};
    }

    static {
        RadialDatasetStandardFactory.registerFactory(Netcdf2Dataset.class);
        RadialDatasetStandardFactory.registerFactory(Dorade2Dataset.class);
        RadialDatasetStandardFactory.registerFactory(LevelII2Dataset.class);
        RadialDatasetStandardFactory.registerFactory(Nids2Dataset.class);
        RadialDatasetStandardFactory.registerFactory(UF2Dataset.class);
    }
}

