/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.messaging;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.remoting.messaging.RemoteSubscriber;
import org.jboss.seam.remoting.messaging.UserTokens;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Name(value="org.jboss.seam.remoting.messaging.subscriptionRegistry")
@Install(value=false, precedence=0)
public class SubscriptionRegistry {
    private static final LogProvider log = Logging.getLogProvider(SubscriptionRegistry.class);
    private String connectionProvider;
    private volatile TopicConnection topicConnection;
    private Object monitor = new Object();
    private Map<String, RemoteSubscriber> subscriptions = new ConcurrentHashMap<String, RemoteSubscriber>();
    private Set<String> allowedTopics = new HashSet<String>();

    public static SubscriptionRegistry instance() {
        SubscriptionRegistry registry = (SubscriptionRegistry)Component.getInstance(SubscriptionRegistry.class);
        if (registry == null) {
            throw new IllegalStateException("No SubscriptionRegistry exists");
        }
        return registry;
    }

    public Set<String> getAllowedTopics() {
        return this.allowedTopics;
    }

    public void setAllowedTopics(Set<String> allowedTopics) {
        this.allowedTopics = allowedTopics;
    }

    public String getConnectionProvider() {
        return this.connectionProvider;
    }

    public void setConnectionProvider(String connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TopicConnection getTopicConnection() throws Exception {
        if (this.topicConnection == null) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.topicConnection == null) {
                    this.topicConnection = org.jboss.seam.jms.TopicConnection.instance();
                    this.topicConnection.setExceptionListener(new ExceptionListener(){

                        public void onException(JMSException ex) {
                        }
                    });
                    this.topicConnection.start();
                }
            }
        }
        return this.topicConnection;
    }

    public RemoteSubscriber subscribe(String topicName) {
        if (!this.allowedTopics.contains(topicName)) {
            throw new IllegalArgumentException(String.format("Cannot subscribe to a topic that is not allowed. Topic [%s] is not an allowed topic.", topicName));
        }
        RemoteSubscriber sub = new RemoteSubscriber(UUID.randomUUID().toString(), topicName);
        try {
            this.subscribe(sub);
            this.subscriptions.put(sub.getToken(), sub);
            this.getUserTokens().add(sub.getToken());
            return sub;
        }
        catch (Exception ex) {
            log.error((Object)ex);
            return null;
        }
    }

    private void subscribe(RemoteSubscriber sub) throws JMSException, Exception {
        try {
            sub.subscribe(this.getTopicConnection());
        }
        catch (Exception e) {
            log.debug((Object)e);
            this.resetTopic();
            sub.subscribe(this.getTopicConnection());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTopic() {
        TopicConnection savedTopic = null;
        Object object = this.monitor;
        synchronized (object) {
            if (this.topicConnection != null) {
                savedTopic = this.topicConnection;
                this.topicConnection = null;
            }
        }
        if (savedTopic != null) {
            try {
                savedTopic.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public UserTokens getUserTokens() {
        return (UserTokens)Component.getInstance(UserTokens.class);
    }

    public RemoteSubscriber getSubscription(String token) {
        if (!this.getUserTokens().contains(token)) {
            throw new IllegalArgumentException("Invalid token argument - token not found in Session Context.");
        }
        return this.subscriptions.get(token);
    }

    public Set<String> getAllTokens() {
        return this.subscriptions.keySet();
    }

    public void cleanupTokens(Set<String> tokens) {
        for (String token : tokens) {
            RemoteSubscriber subscriber = this.subscriptions.remove(token);
            if (subscriber == null) continue;
            try {
                subscriber.unsubscribe();
            }
            catch (Exception e) {
                log.debug((Object)"problem cleaning up subcription", (Throwable)e);
            }
        }
    }
}

