/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.tcp.sampler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.protocol.tcp.sampler.AbstractTCPClient;
import org.apache.jmeter.protocol.tcp.sampler.ReadException;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class BinaryTCPClientImpl
extends AbstractTCPClient {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final int eomInt = JMeterUtils.getPropDefault((String)"tcp.BinaryTCPClient.eomByte", (int)1000);

    public BinaryTCPClientImpl() {
        this.setEolByte(eomInt);
        if (this.useEolByte) {
            log.info("Using eomByte=" + this.eolByte);
        }
    }

    public static final byte[] hexStringToByteArray(String hexEncodedBinary) {
        if (hexEncodedBinary.length() % 2 == 0) {
            char[] sc = hexEncodedBinary.toCharArray();
            byte[] ba = new byte[sc.length / 2];
            for (int i = 0; i < ba.length; ++i) {
                int nibble0 = Character.digit(sc[i * 2], 16);
                int nibble1 = Character.digit(sc[i * 2 + 1], 16);
                if (nibble0 == -1 || nibble1 == -1) {
                    throw new IllegalArgumentException("Hex-encoded binary string contains an invalid hex digit in '" + sc[i * 2] + sc[i * 2 + 1] + "'");
                }
                ba[i] = (byte)(nibble0 << 4 | nibble1);
            }
            return ba;
        }
        throw new IllegalArgumentException("Hex-encoded binary string contains an uneven no. of digits");
    }

    @Override
    public void write(OutputStream os, String hexEncodedBinary) throws IOException {
        os.write(BinaryTCPClientImpl.hexStringToByteArray(hexEncodedBinary));
        os.flush();
        if (log.isDebugEnabled()) {
            log.debug("Wrote: " + hexEncodedBinary);
        }
    }

    @Override
    public void write(OutputStream os, InputStream is) {
        throw new UnsupportedOperationException("Method not supported for Length-Prefixed data.");
    }

    @Override
    public String read(InputStream is) throws ReadException {
        ByteArrayOutputStream w = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[4096];
            int x = 0;
            while ((x = is.read(buffer)) > -1) {
                w.write(buffer, 0, x);
                if (!this.useEolByte || buffer[x - 1] != this.eolByte) continue;
            }
            IOUtils.closeQuietly((OutputStream)w);
            String hexString = JOrphanUtils.baToHexString((byte[])w.toByteArray());
            if (log.isDebugEnabled()) {
                log.debug("Read: " + w.size() + "\n" + hexString);
            }
            return hexString;
        }
        catch (IOException e) {
            throw new ReadException("", e, JOrphanUtils.baToHexString((byte[])w.toByteArray()));
        }
    }
}

