/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.richfaces.component.LayoutPosition;
import org.richfaces.component.UILayout;
import org.richfaces.component.UILayoutPanel;

public class LayoutStructure
implements Serializable {
    private static final long serialVersionUID = -5700775901583881224L;
    private UILayoutPanel top = null;
    private UILayoutPanel bottom = null;
    private UILayoutPanel left = null;
    private UILayoutPanel right = null;
    private UILayoutPanel center = null;
    private int deep = 0;
    private List<Column> columns;

    public LayoutStructure(UILayout layout) {
        this.sortPanels(layout);
    }

    public LayoutStructure(UILayoutPanel panel) {
        UIComponent parent = panel.getParent();
        if (!(parent instanceof UILayout)) {
            throw new FacesException("Layout panel should be children of UILayout pomponent");
        }
        UILayout layout = (UILayout)parent;
        this.sortPanels(layout);
    }

    public void sortPanels(UILayout layout) throws FacesException {
        this.deep = this.layoutDeep((UIComponent)layout);
        for (UIComponent child : layout.getChildren()) {
            if (!(child instanceof UILayoutPanel) || !child.isRendered()) continue;
            UILayoutPanel layoutPanel = (UILayoutPanel)child;
            LayoutPosition position = layoutPanel.getPosition();
            if (LayoutPosition.top.equals((Object)position)) {
                if (null != this.top) {
                    throw new FacesException("Duplicate layoutPanel's with same position" + (Object)((Object)position));
                }
                this.top = layoutPanel;
                continue;
            }
            if (LayoutPosition.bottom.equals((Object)position)) {
                if (null != this.bottom) {
                    throw new FacesException("Duplicate layoutPanel's with same position" + (Object)((Object)position));
                }
                this.bottom = layoutPanel;
                continue;
            }
            if (LayoutPosition.left.equals((Object)position)) {
                if (null != this.left) {
                    throw new FacesException("Duplicate layoutPanel's with same position" + (Object)((Object)position));
                }
                this.left = layoutPanel;
                continue;
            }
            if (LayoutPosition.right.equals((Object)position)) {
                if (null != this.right) {
                    throw new FacesException("Duplicate layoutPanel's with same position" + (Object)((Object)position));
                }
                this.right = layoutPanel;
                continue;
            }
            if (null != position && !LayoutPosition.center.equals((Object)position)) continue;
            if (null != this.center) {
                throw new FacesException("Duplicate layoutPanel's with same position" + (Object)((Object)position));
            }
            this.center = layoutPanel;
        }
        if (null == this.left && null != this.center) {
            this.left = this.center;
            this.center = null;
        }
        if (null == this.left && null != this.right) {
            this.left = this.right;
            this.right = null;
        }
        if (null == this.center && null != this.right) {
            this.center = this.right;
            this.right = null;
        }
        this.columns = new ArrayList<Column>(3);
        if (null != this.left) {
            this.columns.add(new Column(this.left));
        }
        if (null != this.center) {
            this.columns.add(new Column(this.center));
        }
        if (null != this.right) {
            this.columns.add(new Column(this.right));
        }
    }

    public void calculateWidth() throws NumberFormatException {
        if (this.getColumns() > 0) {
            float totalPercent = 0.0f;
            int numOfPercentColumns = 0;
            float totalPart = 0.0f;
            int numOfPartColumns = 0;
            for (Column column : this.columns) {
                String width = column.panel.getWidth();
                if (null == width || 0 == width.length()) {
                    column.partWidth = 1.0f;
                    totalPart += column.partWidth;
                    ++numOfPartColumns;
                    continue;
                }
                if (width.startsWith("*")) {
                    column.partWidth = Float.parseFloat(width.substring(1));
                    totalPart += column.partWidth;
                    ++numOfPartColumns;
                    continue;
                }
                if (!width.endsWith("%")) continue;
                column.percentWidth = Float.parseFloat(width.substring(0, width.length() - 1));
                totalPercent += column.percentWidth;
                ++numOfPercentColumns;
            }
            float partToPercent = 0.0f;
            float percentCoefficient = 1.0f;
            if (numOfPartColumns > 0 && numOfPercentColumns > 0) {
                float rest = 100.0f - totalPercent;
                partToPercent = rest / totalPart;
            } else if (numOfPartColumns > 0) {
                partToPercent = 100.0f / totalPart;
            } else if (numOfPercentColumns == this.columns.size()) {
                percentCoefficient = 100.0f / totalPercent;
            }
            percentCoefficient *= 0.98f;
            for (Column column : this.columns) {
                if (column.partWidth > 0.0f) {
                    column.percentWidth = column.partWidth * partToPercent;
                }
                column.percentWidth = column.percentWidth * percentCoefficient;
            }
        }
    }

    public UILayoutPanel getTop() {
        return this.top;
    }

    public UILayoutPanel getBottom() {
        return this.bottom;
    }

    public UILayoutPanel getLeft() {
        return this.left;
    }

    public UILayoutPanel getRight() {
        return this.right;
    }

    public UILayoutPanel getCenter() {
        return this.center;
    }

    public int getColumns() {
        return this.columns.size();
    }

    public String getWidth(UILayoutPanel panel) {
        return this.getWidth(panel, 1.0f);
    }

    public String getWidth(UILayoutPanel panel, float coeeficient) {
        if (this.top == panel || this.bottom == panel) {
            return panel.getWidth();
        }
        for (Column column : this.columns) {
            if (column.panel != panel) continue;
            if (column.percentWidth > 0.0f) {
                return String.format((Locale)null, "%2.2f%%", Float.valueOf(column.percentWidth * coeeficient));
            }
            return panel.getWidth();
        }
        return null;
    }

    protected int layoutDeep(UIComponent component) {
        int deep = 0;
        if (null != component) {
            deep = this.layoutDeep(component.getParent());
            if (component instanceof UILayout) {
                ++deep;
            }
        }
        return deep;
    }

    public int getDeep() {
        return this.deep;
    }

    static class Column {
        private final UILayoutPanel panel;
        private float percentWidth = 0.0f;
        private float partWidth = 0.0f;

        public Column(UILayoutPanel panel) {
            this.panel = panel;
        }

        public String getWidth() {
            if (this.percentWidth > 0.0f) {
                return String.format((Locale)null, "%2.2f%%", Float.valueOf(this.percentWidth));
            }
            return this.panel.getWidth();
        }

        public float getPercentWidth() {
            return this.percentWidth;
        }
    }
}

