/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.net.URL;
import javax.servlet.ServletContext;
import org.jboss.seam.deployment.FileDescriptor;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDescriptor
extends FileDescriptor {
    private static LogProvider log = Logging.getLogProvider(ClassDescriptor.class);
    private Class<?> clazz;

    public ClassDescriptor(String name, URL url, Class<?> clazz) {
        super(name, url);
        this.clazz = clazz;
    }

    public ClassDescriptor(String name, ClassLoader classLoader, ServletContext servletContext) {
        super(name, classLoader, servletContext);
        String classname = ClassDescriptor.filenameToClassname(name);
        log.trace("Trying to load class " + classname);
        try {
            this.clazz = classLoader.loadClass(classname);
            this.clazz.getAnnotations();
        }
        catch (ClassNotFoundException cnfe) {
            log.debug("could not load class: " + classname, cnfe);
        }
        catch (NoClassDefFoundError ncdfe) {
            log.debug("could not load class (missing dependency): " + classname, ncdfe);
        }
        catch (TypeNotPresentException tnpe) {
            this.clazz = null;
            log.debug("could not load class (annotation missing dependency): " + classname, tnpe);
        }
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    @Override
    public String toString() {
        return this.clazz.getName();
    }

    public static String filenameToClassname(String filename) {
        return filename.substring(0, filename.lastIndexOf(".class")).replace('/', '.').replace('\\', '.');
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ClassDescriptor) {
            ClassDescriptor that = (ClassDescriptor)other;
            return this.getClazz().equals(that.getClazz());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getClazz().hashCode();
    }
}

