/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail.ui;

import java.io.IOException;
import java.io.StringWriter;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jboss.seam.mail.ui.UIMessage;
import org.jboss.seam.mail.ui.context.MailResponseWriter;
import org.jboss.seam.ui.util.JSF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MailComponent
extends UIComponentBase {
    private UIMessage message;
    private static final String FAMILY = "org.jboss.seam.mail";

    public String getFamily() {
        return FAMILY;
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected String encode(FacesContext facesContext) throws IOException {
        return this.encode(facesContext, (UIComponent)this, null, false);
    }

    @Deprecated
    protected String encode(FacesContext facesContext, UIComponent cmp) throws IOException {
        return this.encode(facesContext, cmp, null, true);
    }

    protected String encode(FacesContext facesContext, String contentType) throws IOException {
        return this.encode(facesContext, (UIComponent)this, contentType, false);
    }

    protected String encode(FacesContext facesContext, UIComponent cmp, String contentType) throws IOException {
        return this.encode(facesContext, cmp, contentType, true);
    }

    protected String encode(FacesContext facesContext, UIComponent cmp, String contentType, boolean root) throws IOException {
        ResponseWriter response = facesContext.getResponseWriter();
        StringWriter stringWriter = new StringWriter();
        MailResponseWriter cachingResponseWriter = ((MailResponseWriter)response).cloneWithWriter(stringWriter, contentType);
        facesContext.setResponseWriter((ResponseWriter)cachingResponseWriter);
        if (root) {
            JSF.renderChild((FacesContext)facesContext, (UIComponent)cmp);
        } else {
            JSF.renderChildren((FacesContext)facesContext, (UIComponent)cmp);
        }
        facesContext.setResponseWriter(response);
        String output = stringWriter.getBuffer().toString();
        return output;
    }

    public MimeMessage findMimeMessage() throws MessagingException {
        return this.findMessage().getMimeMessage();
    }

    public UIMessage findMessage() {
        if (this.message == null) {
            this.message = (UIMessage)this.findParent((UIComponent)this, UIMessage.class);
            if (this.message == null) {
                throw new UnsupportedOperationException("Must have a m:message tag in the tree");
            }
        }
        return this.message;
    }

    public MimeMultipart getRootMultipart() throws IOException, MessagingException {
        return (MimeMultipart)this.findMimeMessage().getContent();
    }

    @Deprecated
    public MailComponent findParent(UIComponent parent) {
        return this.findParent(parent, null);
    }

    public MailComponent findParent(UIComponent parent, Class<?> c) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof MailComponent && (c == null || c.isAssignableFrom(parent.getClass()))) {
            return (MailComponent)parent;
        }
        return this.findParent(parent.getParent(), c);
    }

    protected String getString(String localName) {
        if (this.getValue(localName) != null) {
            return this.getValue(localName).toString();
        }
        return null;
    }

    protected Object getValue(String localName) {
        if (this.getValueExpression(localName) == null) {
            return null;
        }
        return this.getValueExpression(localName).getValue(this.getFacesContext().getELContext());
    }

    protected Boolean getBoolean(String localName) {
        Object o = this.getValue(localName);
        if (o != null) {
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            return Boolean.valueOf(o.toString());
        }
        return null;
    }
}

