/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import org.hibernate.Session;
import org.jboss.seam.Component;
import org.jboss.seam.ComponentType;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.annotations.intercept.PostActivate;
import org.jboss.seam.annotations.intercept.PostConstruct;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.persistence.HibernatePersistenceProvider;
import org.jboss.seam.persistence.HibernateSessionProxy;
import org.jboss.seam.util.Reflections;

@Interceptor(stateless=true)
public class HibernateSessionProxyInterceptor
extends AbstractInterceptor {
    @AroundInvoke
    public Object aroundInvoke(InvocationContext ic) throws Exception {
        return ic.proceed();
    }

    @PostActivate
    public void postActivate(InvocationContext invocation) throws Exception {
        this.proxyPersistenceContexts(invocation.getTarget());
        invocation.proceed();
    }

    @PostConstruct
    public void postConstruct(InvocationContext invocation) throws Exception {
        this.proxyPersistenceContexts(invocation.getTarget());
        invocation.proceed();
    }

    private void proxyPersistenceContexts(Object bean) {
        for (Component.BijectedAttribute ba : this.getComponent().getPersistenceContextAttributes()) {
            Object object = ba.get(bean);
            if (object instanceof HibernateSessionProxy || !(object instanceof Session)) continue;
            ba.set(bean, HibernatePersistenceProvider.proxySession((Session)object));
        }
    }

    public boolean isInterceptorEnabled() {
        return (this.getComponent().getType() == ComponentType.STATEFUL_SESSION_BEAN || this.getComponent().getType() == ComponentType.STATELESS_SESSION_BEAN) && Reflections.isClassAvailable("org.hibernate.Session");
    }
}

